/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.filters.PageFilter;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.search.SearchProvider;

public interface SearchManager
extends PageFilter,
InternalModule,
WikiEventListener {
    public static final String DEFAULT_SEARCHPROVIDER = "org.apache.wiki.search.LuceneSearchProvider";
    public static final String PROP_SEARCHPROVIDER = "jspwiki.searchProvider";
    public static final String JSON_SEARCH = "search";

    public SearchProvider getSearchEngine();

    default public Collection<SearchResult> findPages(String query, Context wikiContext) throws ProviderException, IOException {
        if (query == null) {
            query = "";
        }
        return this.getSearchEngine().findPages(query, wikiContext);
    }

    default public void pageRemoved(Page page) {
        this.getSearchEngine().pageRemoved(page);
    }

    default public void reindexPage(Page page) {
        this.getSearchEngine().reindexPage(page);
    }
}

