/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import org.apache.wiki.api.core.Session;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.tags.WikiTagBase;

public class UserCheckTag
extends WikiTagBase {
    private static final long serialVersionUID = 3256438110127863858L;
    private static final String ASSERTED = "asserted";
    private static final String AUTHENTICATED = "authenticated";
    private static final String ANONYMOUS = "anonymous";
    private static final String ASSERTIONS_ALLOWED = "assertionsallowed";
    private static final String ASSERTIONS_NOT_ALLOWED = "assertionsnotallowed";
    private static final String CONTAINER_AUTH = "containerauth";
    private static final String CUSTOM_AUTH = "customauth";
    private static final String KNOWN = "known";
    private static final String NOT_AUTHENTICATED = "notauthenticated";
    private String m_status;

    @Override
    public void initTag() {
        super.initTag();
        this.m_status = null;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status.toLowerCase();
    }

    @Override
    public final int doWikiStartTag() {
        Session session = this.m_wikiContext.getWikiSession();
        String status = session.getStatus();
        AuthenticationManager mgr = (AuthenticationManager)this.m_wikiContext.getEngine().getManager(AuthenticationManager.class);
        boolean containerAuth = mgr.isContainerAuthenticated();
        boolean cookieAssertions = mgr.allowsCookieAssertions();
        if (this.m_status != null) {
            switch (this.m_status) {
                case "anonymous": {
                    if (!status.equals(ANONYMOUS)) break;
                    return 1;
                }
                case "authenticated": {
                    if (!status.equals(AUTHENTICATED)) break;
                    return 1;
                }
                case "asserted": {
                    if (!status.equals(ASSERTED)) break;
                    return 1;
                }
                case "assertionsallowed": {
                    if (cookieAssertions) {
                        return 1;
                    }
                    return 0;
                }
                case "assertionsnotallowed": {
                    if (!cookieAssertions) {
                        return 1;
                    }
                    return 0;
                }
                case "containerauth": {
                    if (containerAuth) {
                        return 1;
                    }
                    return 0;
                }
                case "customauth": {
                    if (!containerAuth) {
                        return 1;
                    }
                    return 0;
                }
                case "known": {
                    if (!session.isAnonymous()) {
                        return 1;
                    }
                    return 0;
                }
                case "notauthenticated": {
                    if (status.equals(AUTHENTICATED)) break;
                    return 1;
                }
            }
        }
        return 0;
    }
}

