/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logger;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.Enablement;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.logger.CallLoggingDetail;

public class CallLoggerRule {
    private final Predicate<Integer> statusFilter;
    private final Predicate<HttpServletRequest> requestFilter;
    private final Predicate<HttpServletResponse> responseFilter;
    private final Predicate<Throwable> exceptionFilter;
    private final Level level;
    private final Enablement enabled;
    private final Predicate<HttpServletRequest> enabledTest;
    private final CallLoggingDetail requestDetail;
    private final CallLoggingDetail responseDetail;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    CallLoggerRule(Builder b) {
        this.statusFilter = b.statusFilter;
        this.exceptionFilter = b.exceptionFilter;
        this.requestFilter = b.requestFilter;
        this.responseFilter = b.responseFilter;
        this.level = b.level;
        this.enabled = b.enabled;
        this.enabledTest = b.enabledTest;
        this.requestDetail = b.requestDetail;
        this.responseDetail = b.responseDetail;
    }

    public boolean matches(HttpServletRequest req, HttpServletResponse res) {
        if (this.requestFilter != null && !this.requestFilter.test(req) || this.responseFilter != null && !this.responseFilter.test(res)) {
            return false;
        }
        if (this.statusFilter != null && !this.statusFilter.test(res.getStatus())) {
            return false;
        }
        Throwable e = (Throwable)req.getAttribute("Exception");
        return e == null || this.exceptionFilter == null || this.exceptionFilter.test(e);
    }

    public CallLoggingDetail getRequestDetail() {
        return this.requestDetail;
    }

    public CallLoggingDetail getResponseDetail() {
        return this.responseDetail;
    }

    public Level getLevel() {
        return this.level;
    }

    public Enablement getEnabled() {
        return this.enabled;
    }

    public Predicate<HttpServletRequest> getEnabledTest() {
        return this.enabledTest;
    }

    public String toString() {
        return JsonMap.filteredMap().append("codeFilter", this.statusFilter).append("exceptionFilter", this.exceptionFilter).append("requestFilter", this.requestFilter).append("responseFilter", this.responseFilter).append("level", (Object)this.level).append("requestDetail", (Object)this.requestDetail).append("responseDetail", (Object)this.responseDetail).append("enabled", (Object)this.enabled).append("enabledTest", this.enabledTest).asReadableString();
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<CallLoggerRule> {
        Predicate<Integer> statusFilter;
        Predicate<HttpServletRequest> requestFilter;
        Predicate<HttpServletResponse> responseFilter;
        Predicate<Throwable> exceptionFilter;
        Enablement enabled;
        Predicate<HttpServletRequest> enabledTest;
        Level level;
        CallLoggingDetail requestDetail;
        CallLoggingDetail responseDetail;
        boolean logStackTrace;

        protected Builder(BeanStore beanStore) {
            super(CallLoggerRule.class, beanStore);
        }

        protected CallLoggerRule buildDefault() {
            return new CallLoggerRule(this);
        }

        public Builder statusFilter(Predicate<Integer> value) {
            this.statusFilter = value;
            return this;
        }

        public Builder exceptionFilter(Predicate<Throwable> value) {
            this.exceptionFilter = value;
            return this;
        }

        public Builder requestFilter(Predicate<HttpServletRequest> value) {
            this.requestFilter = value;
            return this;
        }

        public Builder responseFilter(Predicate<HttpServletResponse> value) {
            this.responseFilter = value;
            return this;
        }

        public Builder enabled(Enablement value) {
            this.enabled = value;
            return this;
        }

        public Builder enabledPredicate(Predicate<HttpServletRequest> value) {
            this.enabledTest = value;
            return this;
        }

        public Builder disabled() {
            return this.enabled(Enablement.NEVER);
        }

        public Builder requestDetail(CallLoggingDetail value) {
            this.requestDetail = value;
            return this;
        }

        public Builder responseDetail(CallLoggingDetail value) {
            this.responseDetail = value;
            return this;
        }

        public Builder level(Level value) {
            this.level = value;
            return this;
        }

        public Builder logStackTrace() {
            this.logStackTrace = true;
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }
}

