/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.juneau.ConfigException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.config.event.ConfigEvent;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEventType;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigMapEntry;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.SimpleLock;
import org.apache.juneau.internal.SimpleReadWriteLock;

public class ConfigMap
implements ConfigStoreListener {
    private final ConfigStore store;
    private volatile String contents;
    final String name;
    private final List<ConfigEvent> changes = CollectionUtils.synced((List)new ConfigEvents());
    private final Set<ConfigEventListener> listeners = CollectionUtils.synced((Set)CollectionUtils.set((Object[])new ConfigEventListener[0]));
    final Map<String, ConfigSection> entries = CollectionUtils.synced((Map)CollectionUtils.map());
    final Map<String, ConfigSection> oentries = CollectionUtils.synced((Map)CollectionUtils.map());
    final List<Import> imports = new CopyOnWriteArrayList<Import>();
    private final SimpleReadWriteLock lock = new SimpleReadWriteLock();

    public ConfigMap(ConfigStore store, String name) throws IOException {
        this.store = store;
        this.name = name;
        this.load(store.read(name));
    }

    ConfigMap(ConfigStore store, String name, String contents) throws IOException {
        this.store = store;
        this.name = name;
        this.load(contents);
    }

    private ConfigMap load(String contents) throws IOException {
        int i;
        String l;
        if (contents == null) {
            contents = "";
        }
        this.contents = contents;
        this.entries.clear();
        this.oentries.clear();
        this.imports.forEach(Import::unregisterAll);
        this.imports.clear();
        LinkedHashMap imports = CollectionUtils.map();
        AbstractList lines = CollectionUtils.linkedList((Object[])new String[0]);
        try (Scanner scanner = new Scanner(contents);){
            while (scanner.hasNextLine()) {
                int i2;
                String line = scanner.nextLine();
                char c = StringUtils.firstChar((String)line);
                char c2 = StringUtils.lastNonWhitespaceChar((String)line);
                if (c == '[') {
                    l = line.trim();
                    if (c2 != ']' || !this.isValidNewSectionName(l.substring(1, l.length() - 1))) {
                        throw new ConfigException("Invalid section name found in configuration:  {0}", new Object[]{line});
                    }
                } else if (c == '<' && (i2 = (l = line.trim()).indexOf(62)) != -1) {
                    String l2 = l.substring(1, i2);
                    if (!this.isValidConfigName(l2)) {
                        throw new ConfigException("Invalid import config name found in configuration:  {0}", new Object[]{line});
                    }
                    String l3 = l.substring(i2 + 1);
                    if (!StringUtils.isEmpty((String)l3) && StringUtils.firstChar((String)l3) != '#') {
                        throw new ConfigException("Invalid import config name found in configuration:  {0}", new Object[]{line});
                    }
                    String importName = l2.trim();
                    try {
                        if (!imports.containsKey(importName)) {
                            imports.put(importName, this.store.getMap(importName));
                        }
                    }
                    catch (StackOverflowError e) {
                        throw new IOException("Import loop detected in configuration '" + this.name + "'->'" + importName + "'");
                    }
                }
                lines.add(line);
            }
        }
        ArrayList irl = CollectionUtils.list((int)imports.size());
        CollectionUtils.forEachReverse((List)CollectionUtils.listFrom(imports.values()), x -> irl.add(new Import((ConfigMap)x).register(this.listeners)));
        this.imports.addAll(irl);
        boolean inserted = false;
        boolean foundComment = false;
        ListIterator<Object> li = lines.listIterator();
        while (li.hasNext()) {
            l = (String)li.next();
            char c = StringUtils.firstNonWhitespaceChar((String)l);
            if (c != '#') {
                if (c != '\u0000' || !foundComment) break;
                li.set("[]");
                inserted = true;
                break;
            }
            foundComment = true;
        }
        if (!inserted) {
            lines.add(0, "[]");
        }
        li = lines.listIterator(lines.size());
        Object accumulator = null;
        while (li.hasPrevious()) {
            String l2 = (String)li.previous();
            char c = StringUtils.firstChar((String)l2);
            if (c == '\t') {
                c = StringUtils.firstNonWhitespaceChar((String)l2);
                if (c == '#') continue;
                accumulator = accumulator == null ? l2.substring(1) : l2.substring(1) + "\n" + (String)accumulator;
                li.remove();
                continue;
            }
            if (accumulator == null) continue;
            li.set(l2 + "\n" + accumulator);
            accumulator = null;
        }
        lines = CollectionUtils.copyOf((List)lines);
        int last = lines.size() - 1;
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        ArrayList sections = CollectionUtils.list((Object[])new ConfigSection[0]);
        for (i = last; i >= 0; --i) {
            String l3 = (String)lines.get(i);
            char c = StringUtils.firstChar((String)l3);
            if (state == S1) {
                if (c != '[') continue;
                state = S2;
                continue;
            }
            if (c == '#' || c != '[' && l3.indexOf(61) == -1) continue;
            sections.add(new ConfigSection(lines.subList(i + 1, last + 1)));
            last = i + 1;
            state = c == '[' ? S2 : S1;
        }
        sections.add(new ConfigSection(lines.subList(0, last + 1)));
        for (i = sections.size() - 1; i >= 0; --i) {
            ConfigSection cs = (ConfigSection)sections.get(i);
            if (this.entries.containsKey(cs.name)) {
                throw new ConfigException("Duplicate section found in configuration:  [{0}]", new Object[]{cs.name});
            }
            this.entries.put(cs.name, cs);
        }
        this.oentries.putAll(this.entries);
        return this;
    }

    public ConfigMapEntry getEntry(String section, String key) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        try (SimpleLock x = this.lock.read();){
            ConfigMapEntry ce;
            ConfigSection cs = this.entries.get(section);
            ConfigMapEntry configMapEntry = ce = cs == null ? null : cs.entries.get(key);
            if (ce == null) {
                ce = this.imports.stream().map(y -> y.getConfigMap().getEntry(section, key)).filter(y -> y != null).findFirst().orElse(null);
            }
            ConfigMapEntry configMapEntry2 = ce;
            return configMapEntry2;
        }
    }

    public List<String> getPreLines(String section) {
        this.checkSectionName(section);
        try (SimpleLock x = this.lock.read();){
            ConfigSection cs = this.entries.get(section);
            List<String> list = cs == null ? null : cs.preLines;
            return list;
        }
    }

    public Set<String> getSections() {
        LinkedHashSet s;
        LinkedHashSet linkedHashSet = s = this.imports.isEmpty() ? this.entries.keySet() : CollectionUtils.set((Object[])new String[0]);
        if (!this.imports.isEmpty()) {
            this.imports.forEach(x -> s.addAll(x.getConfigMap().getSections()));
            s.addAll(this.entries.keySet());
        }
        return CollectionUtils.unmodifiable((Set)s);
    }

    public Set<String> getKeys(String section) {
        LinkedHashSet s;
        this.checkSectionName(section);
        ConfigSection cs = this.entries.get(section);
        Set<Object> set = s = this.imports.isEmpty() && cs != null ? cs.entries.keySet() : CollectionUtils.set((Object[])new String[0]);
        if (!this.imports.isEmpty()) {
            this.imports.forEach(x -> s.addAll(x.getConfigMap().getKeys(section)));
            if (cs != null) {
                s.addAll(cs.entries.keySet());
            }
        }
        return CollectionUtils.unmodifiable((Set)s);
    }

    public boolean hasSection(String section) {
        this.checkSectionName(section);
        return this.entries.get(section) != null || this.imports.stream().anyMatch(x -> x.getConfigMap().hasSection(section));
    }

    public ConfigMap setSection(String section, List<String> preLines) {
        this.checkSectionName(section);
        return this.applyChange(true, ConfigEvent.setSection(this.name, section, preLines));
    }

    public ConfigMap setEntry(String section, String key, String value, String modifiers, String comment, List<String> preLines) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        return this.applyChange(true, ConfigEvent.setEntry(this.name, section, key, value, modifiers, comment, preLines));
    }

    public ConfigMap setImport(String section, String importName, List<String> preLines) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public ConfigMap removeSection(String section) {
        this.checkSectionName(section);
        return this.applyChange(true, ConfigEvent.removeSection(this.name, section));
    }

    public ConfigMap removeEntry(String section, String key) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        return this.applyChange(true, ConfigEvent.removeEntry(this.name, section, key));
    }

    public ConfigMap removeImport(String section, String importName) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    private ConfigMap applyChange(boolean addToChangeList, ConfigEvent ce) {
        if (ce == null) {
            return this;
        }
        try (SimpleLock x = this.lock.write();){
            String section = ce.getSection();
            ConfigSection cs = this.entries.get(section);
            if (ce.getType() == ConfigEventType.SET_ENTRY) {
                ConfigMapEntry oe;
                if (cs == null) {
                    cs = new ConfigSection(section);
                    this.entries.put(section, cs);
                }
                if ((oe = cs.entries.get(ce.getKey())) == null) {
                    oe = ConfigMapEntry.NULL;
                }
                cs.addEntry(ce.getKey(), ce.getValue() == null ? oe.value : ce.getValue(), ce.getModifiers() == null ? oe.modifiers : ce.getModifiers(), ce.getComment() == null ? oe.comment : ce.getComment(), ce.getPreLines() == null ? oe.preLines : ce.getPreLines());
            } else if (ce.getType() == ConfigEventType.SET_SECTION) {
                if (cs == null) {
                    cs = new ConfigSection(section);
                    this.entries.put(section, cs);
                }
                if (ce.getPreLines() != null) {
                    cs.setPreLines(ce.getPreLines());
                }
            } else if (ce.getType() == ConfigEventType.REMOVE_ENTRY) {
                if (cs != null) {
                    cs.entries.remove(ce.getKey());
                }
            } else if (ce.getType() == ConfigEventType.REMOVE_SECTION && cs != null) {
                this.entries.remove(section);
            }
            if (addToChangeList) {
                this.changes.add(ce);
            }
        }
        return this;
    }

    public ConfigMap load(String contents, boolean synchronous) throws IOException, InterruptedException {
        if (synchronous) {
            CountDownLatch latch = new CountDownLatch(1);
            ConfigStoreListener listener = contents1 -> latch.countDown();
            this.store.register(this.name, listener);
            this.store.write(this.name, null, contents);
            latch.await(30L, TimeUnit.SECONDS);
            this.store.unregister(this.name, listener);
        } else {
            this.store.write(this.name, null, contents);
        }
        return this;
    }

    public ConfigMap commit() throws IOException {
        try (SimpleLock x = this.lock.write();){
            String newContents = this.asString();
            for (int i = 0; i <= 10; ++i) {
                if (i == 10) {
                    throw new ConfigException("Unable to store contents of config to store.", new Object[0]);
                }
                String currentContents = this.store.write(this.name, this.contents, newContents);
                if (currentContents == null) break;
                this.onChange(currentContents);
            }
            this.changes.clear();
        }
        return this;
    }

    public ConfigMap register(ConfigEventListener listener) {
        this.listeners.add(listener);
        this.imports.forEach(x -> x.register(listener));
        return this;
    }

    boolean hasEntry(String section, String key) {
        ConfigSection cs = this.entries.get(section);
        ConfigMapEntry ce = cs == null ? null : cs.entries.get(key);
        return ce != null;
    }

    public ConfigMap unregister(ConfigEventListener listener) {
        this.listeners.remove(listener);
        this.imports.forEach(x -> x.register(listener));
        return this;
    }

    public Set<ConfigEventListener> getListeners() {
        return CollectionUtils.unmodifiable(this.listeners);
    }

    @Override
    public void onChange(String newContents) {
        ConfigEvents changes = null;
        try (SimpleLock x = this.lock.write();){
            if (StringUtils.ne((String)this.contents, (String)newContents)) {
                changes = this.findDiffs(newContents);
                this.load(newContents);
                this.changes.forEach(y -> this.applyChange(false, (ConfigEvent)y));
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
        if (changes != null && !changes.isEmpty()) {
            this.signal(changes);
        }
    }

    public String toString() {
        try (SimpleLock x = this.lock.read();){
            String string = this.asString();
            return string;
        }
    }

    public JsonMap asMap() {
        JsonMap m = new JsonMap();
        try (SimpleLock x = this.lock.read();){
            this.imports.forEach(y -> m.putAll((Map)y.getConfigMap().asMap()));
            this.entries.values().forEach(z -> {
                LinkedHashMap m2 = CollectionUtils.map();
                z.entries.values().forEach(y -> m2.put(y.key, y.value));
                m.put(z.name, (Object)m2);
            });
        }
        return m;
    }

    public Writer writeTo(Writer w) throws IOException {
        try (SimpleLock x = this.lock.read();){
            for (ConfigSection cs : this.entries.values()) {
                cs.writeTo(w);
            }
        }
        return w;
    }

    public ConfigMap rollback() {
        if (this.changes.size() > 0) {
            try (SimpleLock x = this.lock.write();){
                this.changes.clear();
                this.load(this.contents);
            }
            catch (IOException e) {
                throw ThrowableUtils.asRuntimeException((Throwable)e);
            }
        }
        return this;
    }

    private void checkSectionName(String s) {
        if (!"".equals(s) && !this.isValidNewSectionName(s)) {
            throw new IllegalArgumentException("Invalid section name: '" + s + "'");
        }
    }

    private void checkKeyName(String s) {
        if (!this.isValidKeyName(s)) {
            throw new IllegalArgumentException("Invalid key name: '" + s + "'");
        }
    }

    private boolean isValidKeyName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\' && c != '[' && c != ']' && c != '=' && c != '#') continue;
            return false;
        }
        return true;
    }

    private boolean isValidNewSectionName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\' && c != '[' && c != ']') continue;
            return false;
        }
        return true;
    }

    private boolean isValidConfigName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
            return false;
        }
        return true;
    }

    private void signal(ConfigEvents changes) {
        if (changes.size() > 0) {
            this.listeners.forEach(x -> x.onConfigChange(changes));
        }
    }

    private ConfigEvents findDiffs(String updatedContents) throws IOException {
        ConfigEvents changes = new ConfigEvents();
        ConfigMap newMap = new ConfigMap(this.store, this.name, updatedContents);
        for (Import i : newMap.imports) {
            if (this.imports.contains(i)) continue;
            for (ConfigSection s : i.getConfigMap().entries.values()) {
                for (ConfigMapEntry e : s.oentries.values()) {
                    if (newMap.hasEntry(s.name, e.key)) continue;
                    changes.add(ConfigEvent.setEntry(this.name, s.name, e.key, e.value, e.modifiers, e.comment, e.preLines));
                }
            }
        }
        for (Import i : this.imports) {
            if (newMap.imports.contains(i)) continue;
            for (ConfigSection s : i.getConfigMap().entries.values()) {
                for (ConfigMapEntry e : s.oentries.values()) {
                    if (newMap.hasEntry(s.name, e.key)) continue;
                    changes.add(ConfigEvent.removeEntry(this.name, s.name, e.key));
                }
            }
        }
        for (ConfigSection ns : newMap.oentries.values()) {
            ConfigSection s = this.oentries.get(ns.name);
            if (s == null) {
                for (ConfigMapEntry ne : ns.entries.values()) {
                    changes.add(ConfigEvent.setEntry(this.name, ns.name, ne.key, ne.value, ne.modifiers, ne.comment, ne.preLines));
                }
                continue;
            }
            for (ConfigMapEntry ne : ns.oentries.values()) {
                ConfigMapEntry e;
                e = s.oentries.get(ne.key);
                if (e != null && !StringUtils.ne((String)e.value, (String)ne.value)) continue;
                changes.add(ConfigEvent.setEntry(this.name, s.name, ne.key, ne.value, ne.modifiers, ne.comment, ne.preLines));
            }
            for (ConfigMapEntry e : s.oentries.values()) {
                ConfigMapEntry ne = ns.oentries.get(e.key);
                if (ne != null) continue;
                changes.add(ConfigEvent.removeEntry(this.name, s.name, e.key));
            }
        }
        for (ConfigSection s : this.oentries.values()) {
            ConfigSection ns = newMap.oentries.get(s.name);
            if (ns != null) continue;
            for (ConfigMapEntry e : s.oentries.values()) {
                changes.add(ConfigEvent.removeEntry(this.name, s.name, e.key));
            }
        }
        return changes;
    }

    private String asString() {
        try {
            StringWriter sw = new StringWriter();
            for (ConfigSection cs : this.entries.values()) {
                cs.writeTo(sw);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    class ConfigSection {
        final String name;
        final List<String> preLines = CollectionUtils.synced((List)CollectionUtils.list((Object[])new String[0]));
        private final String rawLine;
        final Map<String, ConfigMapEntry> oentries = CollectionUtils.synced((Map)CollectionUtils.map());
        final Map<String, ConfigMapEntry> entries = CollectionUtils.synced((Map)CollectionUtils.map());

        ConfigSection(String name) {
            this.name = name;
            this.rawLine = "[" + name + "]";
        }

        ConfigSection(List<String> lines) {
            String name = null;
            String rawLine = null;
            int S1 = 1;
            int S2 = 2;
            int state = S1;
            int start = 0;
            for (int i = 0; i < lines.size(); ++i) {
                String l = lines.get(i);
                char c = StringUtils.firstNonWhitespaceChar((String)l);
                if (state == S1) {
                    if (c == '[') {
                        int i1 = l.indexOf(91);
                        int i2 = l.indexOf(93);
                        name = l.substring(i1 + 1, i2).trim();
                        rawLine = l;
                        state = S2;
                        start = i + 1;
                        continue;
                    }
                    this.preLines.add(l);
                    continue;
                }
                if (c == '#' || l.indexOf(61) == -1) continue;
                ConfigMapEntry e = new ConfigMapEntry(l, lines.subList(start, i));
                if (this.entries.containsKey(e.key)) {
                    throw new ConfigException("Duplicate entry found in section [{0}] of configuration:  {1}", new Object[]{name, e.key});
                }
                this.entries.put(e.key, e);
                start = i + 1;
            }
            this.name = name;
            this.rawLine = rawLine;
            this.oentries.putAll(this.entries);
        }

        ConfigSection addEntry(String key, String value, String modifiers, String comment, List<String> preLines) {
            ConfigMapEntry e = new ConfigMapEntry(key, value, modifiers, comment, preLines);
            this.entries.put(e.key, e);
            return this;
        }

        ConfigSection setPreLines(List<String> preLines) {
            this.preLines.clear();
            this.preLines.addAll(preLines);
            return this;
        }

        Writer writeTo(Writer w) throws IOException {
            for (String s : this.preLines) {
                w.append(s).append('\n');
            }
            if (!this.name.equals("")) {
                w.append(this.rawLine).append('\n');
            } else if (!this.preLines.isEmpty()) {
                w.append('\n');
            }
            for (ConfigMapEntry e : this.entries.values()) {
                e.writeTo(w);
            }
            return w;
        }
    }

    class Import {
        private final ConfigMap configMap;
        private final Map<ConfigEventListener, ConfigEventListener> listenerMap = CollectionUtils.synced((Map)CollectionUtils.map());

        Import(ConfigMap configMap) {
            this.configMap = configMap;
        }

        synchronized Import register(Collection<ConfigEventListener> listeners) {
            listeners.forEach(this::register);
            return this;
        }

        synchronized Import register(ConfigEventListener listener) {
            ConfigEventListener l2 = events -> {
                ConfigEvents events2 = new ConfigEvents();
                events.stream().filter(x -> !ConfigMap.this.hasEntry(x.getSection(), x.getKey())).forEach(x -> events2.add(x));
                if (events2.size() > 0) {
                    listener.onConfigChange(events2);
                }
            };
            this.listenerMap.put(listener, l2);
            this.configMap.register(l2);
            return this;
        }

        synchronized Import unregister(ConfigEventListener listener) {
            this.configMap.unregister(this.listenerMap.remove(listener));
            return this;
        }

        synchronized Import unregisterAll() {
            this.listenerMap.values().forEach(x -> this.configMap.unregister((ConfigEventListener)x));
            this.listenerMap.clear();
            return this;
        }

        String getConfigName() {
            return this.configMap.name;
        }

        ConfigMap getConfigMap() {
            return this.configMap;
        }

        public boolean equals(Object o) {
            Import ir;
            return o instanceof Import && (ir = (Import)o).getConfigName().equals(this.getConfigName());
        }

        public int hashCode() {
            return this.getConfigName().hashCode();
        }
    }
}

