/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.marshaller.Json5;

@Bean(properties="description,type,format,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf,$ref,example,*")
@FluentSetters
public class HeaderInfo
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String description;
    private String type;
    private String format;
    private String collectionFormat;
    private String pattern;
    private String ref;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Items items;
    private Object _default;
    private Set<Object> _enum;
    private Object example;

    public HeaderInfo() {
    }

    public HeaderInfo(HeaderInfo copyFrom) {
        super(copyFrom);
        this.collectionFormat = copyFrom.collectionFormat;
        this._default = copyFrom._default;
        this.description = copyFrom.description;
        this._enum = CollectionUtils.copyOf(copyFrom._enum);
        this.example = copyFrom.example;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.format = copyFrom.format;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.multipleOf = copyFrom.multipleOf;
        this.pattern = copyFrom.pattern;
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
    }

    public HeaderInfo copy() {
        return new HeaderInfo(this);
    }

    @Override
    protected HeaderInfo strict() {
        super.strict();
        return this;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public HeaderInfo setCollectionFormat(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_COLLECTION_FORMATS)) {
            throw new BasicRuntimeException("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = value;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public HeaderInfo setDefault(Object value) {
        this._default = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public HeaderInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Set<Object> getEnum() {
        return this._enum;
    }

    public HeaderInfo setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.setFrom(value);
        return this;
    }

    public HeaderInfo setEnum(Object ... value) {
        return this.setEnum(Arrays.asList(value));
    }

    public HeaderInfo addEnum(Object ... value) {
        this.setEnum(CollectionUtils.setBuilder(this._enum).sparse().add((Object[])value).build());
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public HeaderInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public HeaderInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public HeaderInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public HeaderInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public HeaderInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public HeaderInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public HeaderInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public HeaderInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public HeaderInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public HeaderInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public HeaderInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public HeaderInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public HeaderInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    @Beanp(value="$ref")
    public HeaderInfo setRef(String value) {
        this.ref = value;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public HeaderInfo setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_TYPES)) {
            throw new BasicRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public HeaderInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "collectionFormat": {
                return ConverterUtils.toType(this.getCollectionFormat(), type);
            }
            case "default": {
                return ConverterUtils.toType(this.getDefault(), type);
            }
            case "description": {
                return (T)this.getDescription();
            }
            case "enum": {
                return ConverterUtils.toType(this.getEnum(), type);
            }
            case "example": {
                return ConverterUtils.toType(this.getExample(), type);
            }
            case "exclusiveMaximum": {
                return ConverterUtils.toType(this.getExclusiveMaximum(), type);
            }
            case "exclusiveMinimum": {
                return ConverterUtils.toType(this.getExclusiveMinimum(), type);
            }
            case "format": {
                return ConverterUtils.toType(this.getFormat(), type);
            }
            case "items": {
                return ConverterUtils.toType(this.getItems(), type);
            }
            case "maximum": {
                return ConverterUtils.toType(this.getMaximum(), type);
            }
            case "maxItems": {
                return ConverterUtils.toType(this.getMaxItems(), type);
            }
            case "maxLength": {
                return ConverterUtils.toType(this.getMaxLength(), type);
            }
            case "minimum": {
                return ConverterUtils.toType(this.getMinimum(), type);
            }
            case "minItems": {
                return ConverterUtils.toType(this.getMinItems(), type);
            }
            case "minLength": {
                return ConverterUtils.toType(this.getMinLength(), type);
            }
            case "multipleOf": {
                return ConverterUtils.toType(this.getMultipleOf(), type);
            }
            case "pattern": {
                return ConverterUtils.toType(this.getPattern(), type);
            }
            case "$ref": {
                return ConverterUtils.toType(this.getRef(), type);
            }
            case "type": {
                return ConverterUtils.toType(this.getType(), type);
            }
            case "uniqueItems": {
                return ConverterUtils.toType(this.getUniqueItems(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public HeaderInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "collectionFormat": {
                return this.setCollectionFormat(StringUtils.stringify(value));
            }
            case "default": {
                return this.setDefault(value);
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "enum": {
                return this.setEnum(CollectionUtils.setBuilder(Object.class, new Type[0]).sparse().addAny(value).build());
            }
            case "example": {
                return this.setExample(value);
            }
            case "exclusiveMaximum": {
                return this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
            }
            case "exclusiveMinimum": {
                return this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
            }
            case "format": {
                return this.setFormat(StringUtils.stringify(value));
            }
            case "items": {
                return this.setItems(ConverterUtils.toType(value, Items.class));
            }
            case "maximum": {
                return this.setMaximum(ConverterUtils.toNumber(value));
            }
            case "maxItems": {
                return this.setMaxItems(ConverterUtils.toInteger(value));
            }
            case "maxLength": {
                return this.setMaxLength(ConverterUtils.toInteger(value));
            }
            case "minimum": {
                return this.setMinimum(ConverterUtils.toNumber(value));
            }
            case "minItems": {
                return this.setMinItems(ConverterUtils.toInteger(value));
            }
            case "minLength": {
                return this.setMinLength(ConverterUtils.toInteger(value));
            }
            case "multipleOf": {
                return this.setMultipleOf(ConverterUtils.toNumber(value));
            }
            case "pattern": {
                return this.setPattern(StringUtils.stringify(value));
            }
            case "$ref": {
                return this.setRef(StringUtils.stringify(value));
            }
            case "type": {
                return this.setType(StringUtils.stringify(value));
            }
            case "uniqueItems": {
                return this.setUniqueItems(ConverterUtils.toBoolean(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.collectionFormat != null, "collectionFormat").addIf(this._default != null, "default").addIf(this.description != null, "description").addIf(this._enum != null, "enum").addIf(this.example != null, "example").addIf(this.exclusiveMaximum != null, "exclusiveMaximum").addIf(this.exclusiveMinimum != null, "exclusiveMinimum").addIf(this.format != null, "format").addIf(this.items != null, "items").addIf(this.maximum != null, "maximum").addIf(this.maxItems != null, "maxItems").addIf(this.maxLength != null, "maxLength").addIf(this.minimum != null, "minimum").addIf(this.minItems != null, "minItems").addIf(this.minLength != null, "minLength").addIf(this.multipleOf != null, "multipleOf").addIf(this.pattern != null, "pattern").addIf(this.ref != null, "$ref").addIf(this.type != null, "type").addIf(this.uniqueItems != null, "uniqueItems").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public HeaderInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.ref != null) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            HeaderInfo r = swagger.findRef(this.ref, HeaderInfo.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }
}

