/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IOUtils {
    private static final Pattern JDOC_PATTERN = Pattern.compile("(?s)\\/\\*\\*.*?\\*\\/");

    public static String readFile(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, "UTF-8");
    }

    public static List<String> findJavadocs(String contents) {
        ArrayList<String> l = new ArrayList<String>();
        Matcher m = JDOC_PATTERN.matcher(contents);
        while (m.find()) {
            l.add(m.group());
        }
        return l;
    }

    public static String read(File f) throws IOException {
        return IOUtils.readFile(f.getAbsolutePath());
    }

    public static void writeFile(String path, String contents) throws IOException {
        Files.write(Paths.get(path, new String[0]), contents.getBytes("UTF-8"), new OpenOption[0]);
    }
}

