/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;

abstract class RegionDigraphVisitorBase<C>
implements RegionDigraphVisitor {
    private final Collection<C> allCandidates;
    private final Stack<Set<C>> allowedStack = new Stack();
    private final Stack<Collection<C>> filteredStack = new Stack();
    private final Object monitor;
    private Set<C> allowed;

    protected RegionDigraphVisitorBase(Collection<C> candidates) {
        this.allCandidates = candidates;
        this.allowed = new HashSet<C>();
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<C> getAllowed() {
        Object object = this.monitor;
        synchronized (object) {
            return this.allowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allow(C candidate) {
        Object object = this.monitor;
        synchronized (object) {
            this.allowed.add(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allow(Collection<C> candidates) {
        Object object = this.monitor;
        synchronized (object) {
            this.allowed.addAll(candidates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAllowed() {
        Object object = this.monitor;
        synchronized (object) {
            this.allowedStack.push(this.allowed);
            this.allowed = new HashSet<C>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<C> popAllowed() {
        Object object = this.monitor;
        synchronized (object) {
            Set<C> a = this.allowed;
            this.allowed = this.allowedStack.pop();
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFiltered(Collection<C> filtered) {
        Object object = this.monitor;
        synchronized (object) {
            this.filteredStack.push(filtered);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<C> popFiltered() {
        Object object = this.monitor;
        synchronized (object) {
            return this.filteredStack.isEmpty() ? this.allCandidates : this.filteredStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<C> peekFiltered() {
        Object object = this.monitor;
        synchronized (object) {
            return this.filteredStack.isEmpty() ? this.allCandidates : this.filteredStack.peek();
        }
    }

    @Override
    public boolean visit(Region region) {
        Collection<C> candidates = this.peekFiltered();
        for (C candidate : candidates) {
            if (!this.contains(region, candidate)) continue;
            this.allow(candidate);
        }
        return !this.allowed.containsAll(candidates);
    }

    protected abstract boolean contains(Region var1, C var2);

    @Override
    public boolean preEdgeTraverse(RegionFilter regionFilter) {
        ArrayList<C> candidates = new ArrayList<C>(this.peekFiltered());
        candidates.removeAll(this.allowed);
        this.filter(candidates, regionFilter);
        if (candidates.isEmpty()) {
            return false;
        }
        this.pushFiltered(candidates);
        this.pushAllowed();
        return true;
    }

    @Override
    public void postEdgeTraverse(RegionFilter regionFilter) {
        this.popFiltered();
        Collection<C> candidates = this.popAllowed();
        this.allow(candidates);
    }

    private void filter(Collection<C> candidates, RegionFilter filter) {
        Iterator<C> i = candidates.iterator();
        while (i.hasNext()) {
            C candidate = i.next();
            if (this.isAllowed(candidate, filter)) continue;
            i.remove();
        }
    }

    protected abstract boolean isAllowed(C var1, RegionFilter var2);
}

