/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;

public class TransformerListCommand
extends AbstractCamelCommand {
    private static final String CONTEXT_NAME_COLUMN_LABEL = "Context";
    private static final String SCHEME_COLUMN_LABEL = "Scheme";
    private static final String FROM_COLUMN_LABEL = "From";
    private static final String TO_COLUMN_LABEL = "To";
    private static final String STATE_COLUMN_LABEL = "State";
    private static final String DESCRIPTION_COLUMN_LABEL = "Description";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    boolean decode = true;
    boolean verbose;
    boolean explain;
    private final String context;

    public TransformerListCommand(String context, boolean decode, boolean verbose, boolean explain) {
        this.decode = decode;
        this.verbose = verbose;
        this.explain = explain;
        this.context = context;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> camelContextInfos = camelController.getCamelContexts(this.context);
        HashMap<String, List<Map<String, String>>> contextsToTransformers = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> camelContextInfo : camelContextInfos) {
            String camelContextName = camelContextInfo.get("name");
            List<Map<String, String>> transformers = camelController.getTransformers(camelContextName);
            if (transformers.isEmpty()) continue;
            contextsToTransformers.put(camelContextName, transformers);
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(contextsToTransformers);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        for (Map.Entry stringListEntry : contextsToTransformers.entrySet()) {
            String camelContextName = (String)stringListEntry.getKey();
            List transformers = (List)stringListEntry.getValue();
            if (this.verbose) {
                out.println(String.format(headerFormat, CONTEXT_NAME_COLUMN_LABEL, SCHEME_COLUMN_LABEL, FROM_COLUMN_LABEL, TO_COLUMN_LABEL, STATE_COLUMN_LABEL, DESCRIPTION_COLUMN_LABEL));
                out.println(String.format(headerFormat, "-------", "------", "----", "--", "-----", "-----------"));
            } else {
                out.println(String.format(headerFormat, CONTEXT_NAME_COLUMN_LABEL, SCHEME_COLUMN_LABEL, FROM_COLUMN_LABEL, TO_COLUMN_LABEL, STATE_COLUMN_LABEL));
                out.println(String.format(headerFormat, "-------", "------", "----", "--", "-----"));
            }
            for (Map row : transformers) {
                String scheme = (String)row.get("scheme");
                String from = (String)row.get("from");
                String to = (String)row.get("to");
                String state = (String)row.get("state");
                if (this.verbose) {
                    String desc = (String)row.get("description");
                    out.println(String.format(rowFormat, camelContextName, scheme, from, to, state, desc));
                    continue;
                }
                out.println(String.format(rowFormat, camelContextName, scheme, from, to, state));
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Map<String, List<Map<String, String>>> contextsToTransformers) throws Exception {
        int maxCamelContextLen = 0;
        int maxSchemeLen = 0;
        int maxFromLen = 0;
        int maxToLen = 0;
        int maxStatusLen = 0;
        int maxDescLen = 0;
        for (Map.Entry<String, List<Map<String, String>>> stringListEntry : contextsToTransformers.entrySet()) {
            String camelContextName = stringListEntry.getKey();
            maxCamelContextLen = Math.max(maxCamelContextLen, camelContextName.length());
            List<Map<String, String>> transformers = stringListEntry.getValue();
            for (Map<String, String> row : transformers) {
                String scheme = row.get("scheme");
                maxSchemeLen = Math.max(maxSchemeLen, scheme == null ? 0 : scheme.length());
                String from = row.get("from");
                maxFromLen = Math.max(maxFromLen, from == null ? 0 : from.length());
                String to = row.get("to");
                maxToLen = Math.max(maxToLen, to == null ? 0 : to.length());
                String status = row.get("state");
                maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
                if (!this.verbose) continue;
                String desc = row.get("description");
                maxDescLen = Math.max(maxDescLen, desc == null ? 0 : desc.length());
            }
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(CONTEXT_NAME_COLUMN_LABEL, maxCamelContextLen);
        retval.put(SCHEME_COLUMN_LABEL, maxSchemeLen);
        retval.put(FROM_COLUMN_LABEL, maxFromLen);
        retval.put(TO_COLUMN_LABEL, maxToLen);
        retval.put(STATE_COLUMN_LABEL, maxStatusLen);
        if (this.verbose) {
            retval.put(DESCRIPTION_COLUMN_LABEL, maxDescLen);
        }
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int ctxLen = Math.min(columnWidths.get(CONTEXT_NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        ctxLen = Math.max(12, ctxLen);
        int schemeLen = Math.min(columnWidths.get(SCHEME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        schemeLen = Math.max(12, schemeLen);
        int fromLen = Math.min(columnWidths.get(FROM_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        fromLen = Math.max(12, fromLen);
        int toLen = Math.min(columnWidths.get(TO_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        toLen = Math.max(12, toLen);
        int stateLen = -1;
        if (this.verbose) {
            stateLen = Math.min(columnWidths.get(STATE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            stateLen = Math.max(12, stateLen);
        }
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(ctxLen).append('.').append(ctxLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(schemeLen).append('.').append(schemeLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(fromLen).append('.').append(fromLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(toLen).append('.').append(toLen).append('s').append(fieldPostamble).append(' ');
        if (this.verbose) {
            retval.append(fieldPreamble).append("%-").append(stateLen).append('.').append(stateLen).append('s').append(fieldPostamble).append(' ');
        }
        retval.append(fieldPreamble).append("%s").append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

