/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileDefaultMoveExistingFileStrategy
implements FileMoveExistingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileDefaultMoveExistingFileStrategy.class);

    @Override
    public boolean moveExistingFile(GenericFileEndpoint endpoint, GenericFileOperations operations, String fileName) throws GenericFileOperationFailedException {
        Exchange dummy = endpoint.createExchange();
        String parent = FileUtil.onlyPath((String)fileName);
        String onlyName = FileUtil.stripPath((String)fileName);
        dummy.getIn().setHeader("CamelFileName", (Object)fileName);
        dummy.getIn().setHeader("CamelFileNameOnly", (Object)onlyName);
        dummy.getIn().setHeader("CamelFileParent", (Object)parent);
        String to = (String)endpoint.getMoveExisting().evaluate(dummy, String.class);
        to = FileUtil.normalizePath((String)to);
        if (ObjectHelper.isEmpty((Object)to)) {
            throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
        }
        File toFile = new File(to);
        String directory = toFile.getParent();
        boolean absolute = FileUtil.isAbsolute((File)toFile);
        if (directory != null && !operations.buildDirectory(directory, absolute)) {
            LOG.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
        }
        if (operations.existsFile(to)) {
            if (endpoint.isEagerDeleteTargetFile()) {
                LOG.trace("Deleting existing file: {}", (Object)to);
                if (!operations.deleteFile(to)) {
                    throw new GenericFileOperationFailedException("Cannot delete file: " + to);
                }
            } else {
                throw new GenericFileOperationFailedException("Cannot move existing file from: " + fileName + " to: " + to + " as there already exists a file: " + to);
            }
        }
        LOG.trace("Moving existing file: {} to: {}", (Object)fileName, (Object)to);
        if (!operations.renameFile(fileName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + to);
        }
        return true;
    }
}

