/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.util.Collection;
import java.util.Collections;
import org.apache.felix.webconsole.plugins.ds.internal.ConfigurationAdminSupport;
import org.apache.felix.webconsole.plugins.ds.internal.MetatypeSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationSupport {
    private final ServiceTracker<Object, Object> configAdminTracker;
    private final ServiceTracker<Object, Object> metatypeTracker;

    public ConfigurationSupport(BundleContext bundleContext) {
        this.configAdminTracker = new ServiceTracker(bundleContext, "org.osgi.service.cm.ConfigurationAdmin", null);
        this.metatypeTracker = new ServiceTracker(bundleContext, "org.osgi.service.metatype.MetaTypeService", null);
        this.configAdminTracker.open();
        this.metatypeTracker.open();
    }

    public void close() {
        this.configAdminTracker.close();
        this.metatypeTracker.close();
    }

    public boolean isConfigurable(Bundle providingBundle, String pid) {
        Object mts;
        Object ca = this.configAdminTracker.getService();
        if (ca != null && new ConfigurationAdminSupport().check(ca, pid)) {
            return true;
        }
        if (providingBundle != null && (mts = this.metatypeTracker.getService()) != null) {
            return new MetatypeSupport().check(mts, providingBundle, pid);
        }
        return false;
    }

    public Collection<String> getPasswordAttributeDefinitionIds(Bundle bundle, String[] configurationPids) {
        Object metaTypeService = this.metatypeTracker.getService();
        if (bundle == null || metaTypeService == null) {
            return Collections.emptySet();
        }
        return new MetatypeSupport().getPasswordAttributeDefinitionIds(metaTypeService, bundle, configurationPids);
    }
}

