/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connector.impl;

import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.ops4j.pax.transx.connector.impl.NamedXAResourceWithConnection;
import org.ops4j.pax.transx.connector.impl.WrapperNamedXAResource;
import org.ops4j.pax.transx.tm.NamedResource;
import org.ops4j.pax.transx.tm.ResourceFactory;

public class RecoverableResourceFactoryImpl
implements ResourceFactory {
    private final ManagedConnectionFactory managedConnectionFactory;
    private final String name;

    public RecoverableResourceFactoryImpl(ManagedConnectionFactory managedConnectionFactory, String name) {
        this.managedConnectionFactory = managedConnectionFactory;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public NamedResource create() {
        try {
            ManagedConnection mc = this.managedConnectionFactory.createManagedConnection(null, null);
            WrapperNamedXAResource xares = new WrapperNamedXAResource(mc.getXAResource(), this.name);
            return new NamedXAResourceWithConnection(mc, xares);
        }
        catch (ResourceException e) {
            throw new RuntimeException("Could not get XAResource for recovery for: " + this.name, e);
        }
    }

    public void release(NamedResource resource) {
        NamedXAResourceWithConnection named = (NamedXAResourceWithConnection)resource;
        ManagedConnection mc = named.getManagedConnection();
        try {
            mc.destroy();
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
    }
}

