/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.support.PatternHelper;

public class HealthCheckRegistryRepository
implements CamelContextAware,
HealthCheckRepository {
    private CamelContext context;
    private Map<String, HealthCheckConfiguration> configurations;
    private HealthCheckConfiguration fallbackConfiguration;
    private boolean enabled = true;

    public String getId() {
        return "registry-health-check-repository";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public Map<String, HealthCheckConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, HealthCheckConfiguration> configurations) {
        this.configurations = configurations;
    }

    public void addConfiguration(String id, HealthCheckConfiguration configuration) {
        if ("*".equals(id)) {
            this.fallbackConfiguration = configuration;
        } else {
            if (this.configurations == null) {
                this.configurations = new LinkedHashMap<String, HealthCheckConfiguration>();
            }
            this.configurations.put(id, configuration);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Stream<HealthCheck> stream() {
        if (this.context != null && this.enabled) {
            Set set = this.context.getRegistry().findByType(HealthCheck.class);
            return set.stream().map(this::toHealthCheck);
        }
        return Stream.empty();
    }

    private HealthCheck toHealthCheck(HealthCheck hc) {
        HealthCheckConfiguration hcc;
        if (this.configurations != null && (hcc = this.matchConfiguration(hc.getId())) != null) {
            hc.getConfiguration().setEnabled(hcc.isEnabled());
            hc.getConfiguration().setInterval(hcc.getInterval());
            hc.getConfiguration().setFailureThreshold(hcc.getFailureThreshold());
        }
        return hc;
    }

    private HealthCheckConfiguration matchConfiguration(String id) {
        return this.configurations.values().stream().filter(s -> PatternHelper.matchPattern((String)id, (String)s.getParent())).findAny().orElse(this.fallbackConfiguration);
    }
}

