/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.util.StringHelper;

public class DeadLetterChannelReifier
extends DefaultErrorHandlerReifier<DeadLetterChannelBuilder> {
    public DeadLetterChannelReifier(Route route, ErrorHandlerFactory definition) {
        super(route, definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        this.validateDeadLetterUri();
        DeadLetterChannel answer = new DeadLetterChannel(this.camelContext, processor, ((DeadLetterChannelBuilder)this.definition).getLogger(), this.getBean(Processor.class, ((DeadLetterChannelBuilder)this.definition).getOnRedelivery(), ((DeadLetterChannelBuilder)this.definition).getOnRedeliveryRef()), ((DeadLetterChannelBuilder)this.definition).getRedeliveryPolicy(), ((DeadLetterChannelBuilder)this.definition).getExceptionPolicyStrategy(), this.getBean(Processor.class, ((DeadLetterChannelBuilder)this.definition).getFailureProcessor(), ((DeadLetterChannelBuilder)this.definition).getFailureProcessorRef()), ((DeadLetterChannelBuilder)this.definition).getDeadLetterUri(), ((DeadLetterChannelBuilder)this.definition).isDeadLetterHandleNewException(), ((DeadLetterChannelBuilder)this.definition).isUseOriginalMessage(), ((DeadLetterChannelBuilder)this.definition).isUseOriginalBody(), ((DeadLetterChannelBuilder)this.definition).getRetryWhilePolicy(this.camelContext), this.getExecutorService(((DeadLetterChannelBuilder)this.definition).getExecutorService(), ((DeadLetterChannelBuilder)this.definition).getExecutorServiceRef()), this.getBean(Processor.class, ((DeadLetterChannelBuilder)this.definition).getOnPrepareFailure(), ((DeadLetterChannelBuilder)this.definition).getOnPrepareFailureRef()), this.getBean(Processor.class, ((DeadLetterChannelBuilder)this.definition).getOnExceptionOccurred(), ((DeadLetterChannelBuilder)this.definition).getOnExceptionOccurredRef()));
        this.configure((ErrorHandler)answer);
        return answer;
    }

    protected void validateDeadLetterUri() {
        Endpoint deadLetter = ((DeadLetterChannelBuilder)this.definition).getDeadLetter();
        String deadLetterUri = ((DeadLetterChannelBuilder)this.definition).getDeadLetterUri();
        if (deadLetter == null) {
            StringHelper.notEmpty((String)deadLetterUri, (String)"deadLetterUri", (Object)this);
            deadLetter = this.camelContext.getEndpoint(deadLetterUri);
            if (deadLetter == null) {
                throw new NoSuchEndpointException(deadLetterUri);
            }
            ((DeadLetterChannelBuilder)this.definition).setDeadLetter(deadLetter);
        }
    }
}

