/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@JdkService(value="modelxml-dumper")
public class JaxbModelToXMLDumper
implements ModelToXMLDumper {
    public String dumpModelAsXml(CamelContext context, NamedNode definition) throws Exception {
        Document dom;
        JAXBContext jaxbContext = JaxbModelToXMLDumper.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        if (definition instanceof RouteTemplatesDefinition) {
            List templates = ((RouteTemplatesDefinition)definition).getRouteTemplates();
            for (RouteTemplateDefinition route : templates) {
                JaxbModelToXMLDumper.extractNamespaces(route.getRoute(), namespaces);
            }
        } else if (definition instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template = (RouteTemplateDefinition)definition;
            JaxbModelToXMLDumper.extractNamespaces(template.getRoute(), namespaces);
        } else if (definition instanceof RoutesDefinition) {
            List routes = ((RoutesDefinition)definition).getRoutes();
            for (RouteTemplateDefinition route : routes) {
                JaxbModelToXMLDumper.extractNamespaces((RouteDefinition)route, namespaces);
            }
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)definition;
            JaxbModelToXMLDumper.extractNamespaces(route, namespaces);
        }
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, (Writer)buffer);
        XmlConverter xmlConverter = JaxbModelToXMLDumper.newXmlConverter(context);
        String xml = buffer.toString();
        try {
            dom = xmlConverter.toDOMDocument(xml, null);
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        Element documentElement = dom.getDocumentElement();
        for (String nsPrefix : namespaces.keySet()) {
            String prefix = nsPrefix.equals("xmlns") ? nsPrefix : "xmlns:" + nsPrefix;
            documentElement.setAttribute(prefix, (String)namespaces.get(nsPrefix));
        }
        Properties outputProperties = new Properties();
        outputProperties.put("indent", "yes");
        outputProperties.put("standalone", "yes");
        outputProperties.put("encoding", "UTF-8");
        try {
            return xmlConverter.toStringFromDocument(dom, outputProperties);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed converting document object to string", e);
        }
    }

    public String dumpModelAsXml(final CamelContext context, NamedNode definition, final boolean resolvePlaceholders, final boolean resolveDelegateEndpoints) throws Exception {
        String xml = this.dumpModelAsXml(context, definition);
        if (resolvePlaceholders || resolveDelegateEndpoints) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){
                private String prev;

                public String transform(String text) {
                    String after = text;
                    if (resolveDelegateEndpoints && "uri".equals(this.prev)) {
                        try {
                            String uri = context.resolvePropertyPlaceholders(text);
                            Endpoint endpoint = context.hasEndpoint(uri);
                            if (endpoint instanceof DelegateEndpoint) {
                                endpoint = ((DelegateEndpoint)endpoint).getEndpoint();
                                after = endpoint.getEndpointUri();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (resolvePlaceholders) {
                        try {
                            after = context.resolvePropertyPlaceholders(after);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!changed.get()) {
                        changed.set(!text.equals(after));
                    }
                    this.prev = text;
                    return after;
                }
            });
            if (changed.get()) {
                xml = (String)context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom);
                ExtendedCamelContext ecc = (ExtendedCamelContext)context.adapt(ExtendedCamelContext.class);
                NamedNode copy = ecc.getXMLRoutesDefinitionLoader().createModelFromXml(context, xml, NamedNode.class);
                xml = ecc.getModelToXMLDumper().dumpModelAsXml(context, copy);
            }
        }
        return xml;
    }

    private static JAXBContext getJAXBContext(CamelContext context) throws Exception {
        ModelJAXBContextFactory factory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getModelJAXBContextFactory();
        return (JAXBContext)factory.newJAXBContext();
    }

    private static void extractNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Iterator it = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ExpressionNode.class);
        while (it.hasNext()) {
            Map map;
            NamespaceAware na = JaxbModelToXMLDumper.getNamespaceAwareFromExpression((ExpressionNode)it.next());
            if (na == null || (map = na.getNamespaces()) == null || map.isEmpty()) continue;
            namespaces.putAll(map);
        }
    }

    private static NamespaceAware getNamespaceAwareFromExpression(ExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            na = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            na = (NamespaceAware)ed;
        }
        return na;
    }

    private static XmlConverter newXmlConverter(CamelContext context) {
        XmlConverter xmlConverter;
        if (context != null) {
            TypeConverterRegistry registry = context.getTypeConverterRegistry();
            xmlConverter = (XmlConverter)registry.getInjector().newInstance(XmlConverter.class, false);
        } else {
            xmlConverter = new XmlConverter();
        }
        return xmlConverter;
    }
}

