/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.exporter.executable;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.export.Exporter;
import aQute.bnd.version.Version;
import aQute.lib.collections.ExtList;
import aQute.lib.converter.Converter;
import aQute.lib.strings.Strings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

@BndPlugin(name="exporter.executablejar", hide=true)
public class ExecutableJarExporter
implements Exporter {
    public static final String EXECUTABLE_JAR = "bnd.executablejar";
    public static final String EXECUTABLE_PACK = "bnd.executablejar.pack";

    @Override
    public String[] getTypes() {
        return new String[]{EXECUTABLE_JAR, EXECUTABLE_PACK};
    }

    @Override
    public Map.Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {
        project.prepare();
        Jar jar = null;
        if (EXECUTABLE_JAR.equals(type)) {
            jar = this.defaultExporter(project, options);
        } else if (EXECUTABLE_PACK.equals(type)) {
            String profile = options.getOrDefault("-profile", project.getProfile());
            jar = ExecutableJarExporter.pack(project, profile);
        } else {
            project.error("Unknown type %s", type);
        }
        if (jar == null) {
            return null;
        }
        String name = jar.getName();
        String[] baseext = Strings.extension(name);
        if (baseext != null && ("bnd".equals(baseext[1]) || "bndrun".equals(baseext[1]))) {
            name = baseext[0];
        }
        name = name + ".jar";
        return new AbstractMap.SimpleEntry<String, Resource>(name, new JarResource(jar, true));
    }

    private Jar defaultExporter(Project project, Map<String, String> options) throws Exception, IOException {
        Jar jar;
        try (ProjectLauncher launcher = project.getProjectLauncher();){
            Configuration configuration = Converter.cnv(Configuration.class, options);
            launcher.setKeep(configuration.keep() || project.getRunKeep());
            jar = launcher.executable();
            launcher.removeClose(jar);
            project.getInfo(launcher);
        }
        return jar;
    }

    public static Jar pack(Project project, String profile) throws Exception {
        ExtList<String> ignore = new ExtList<String>((Collection<String>)Constants.BUNDLE_SPECIFIC_HEADERS);
        try (ProjectBuilder pb = project.getBuilder(null);){
            Jar jar;
            block18: {
                ignore.remove("Bundle-SymbolicName");
                ignore.remove("Bundle-Version");
                ignore.add("Service-Component");
                ProjectLauncher launcher = project.getProjectLauncher();
                try {
                    launcher.getRunProperties().put("profile", profile);
                    launcher.getRunProperties().put("-profile", profile);
                    Jar jar2 = launcher.executable();
                    Manifest m = jar2.getManifest();
                    Attributes main = m.getMainAttributes();
                    for (String key : project) {
                        String value;
                        if (!Character.isUpperCase(key.charAt(0)) || ignore.contains(key) || (value = project.getProperty(key)) == null) continue;
                        Attributes.Name name = new Attributes.Name(key);
                        String trimmed = value.trim();
                        if (trimmed.isEmpty()) {
                            main.remove(name);
                            continue;
                        }
                        if ("<<EMPTY>>".equals(trimmed)) {
                            main.put(name, "");
                            continue;
                        }
                        main.put(name, value);
                    }
                    if (main.getValue("Bundle-SymbolicName") == null) {
                        main.putValue("Bundle-SymbolicName", pb.getBsn());
                    }
                    if (main.getValue("Bundle-SymbolicName") == null) {
                        main.putValue("Bundle-SymbolicName", project.getName());
                    }
                    if (main.getValue("Bundle-Version") == null) {
                        main.putValue("Bundle-Version", Version.LOWEST.toString());
                        project.warning("No version set, uses 0.0.0", new Object[0]);
                    }
                    jar2.setManifest(m);
                    jar2.calcChecksums(new String[]{"SHA1", "MD5"});
                    launcher.removeClose(jar2);
                    jar = jar2;
                    if (launcher == null) break block18;
                }
                catch (Throwable throwable) {
                    if (launcher != null) {
                        try {
                            launcher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                launcher.close();
            }
            return jar;
        }
    }

    static interface Configuration {
        public boolean keep();
    }
}

