/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterApplyDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterBufferDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDetectDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterGroupDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterPathDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterScopeDescriptor;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XmlFilterReader
extends Reader {
    private static final UrlRewriteResources RES = (UrlRewriteResources)ResourcesFactory.get(UrlRewriteResources.class);
    private static final String DEFAULT_XML_VERSION = "1.0";
    private static final UrlRewriteFilterPathDescriptor.Compiler<XPathExpression> XPATH_COMPILER = new XmlPathCompiler();
    private static final UrlRewriteFilterPathDescriptor.Compiler<Pattern> REGEX_COMPILER = new RegexCompiler();
    private Reader reader;
    private UrlRewriteFilterContentDescriptor config;
    private int offset;
    private StringWriter writer;
    private StringBuffer buffer;
    private XMLInputFactory factory;
    private XMLEventReader parser;
    private Document document;
    private Stack<Level> stack;
    private boolean isEmptyElement;

    protected XmlFilterReader(Reader reader, UrlRewriteFilterContentDescriptor config) throws IOException, XMLStreamException {
        this.reader = reader;
        this.config = config;
        this.writer = new StringWriter();
        this.buffer = this.writer.getBuffer();
        this.offset = 0;
        this.document = null;
        this.stack = new Stack();
        this.isEmptyElement = false;
        this.factory = XMLInputFactory.newFactory();
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
        this.parser = this.factory.createXMLEventReader(reader);
    }

    protected abstract String filterAttribute(QName var1, QName var2, String var3, String var4);

    protected abstract String filterText(QName var1, String var2, String var3);

    @Override
    public int read(char[] destBuffer, int destOffset, int destCount) throws IOException {
        int count = 0;
        int available = this.buffer.length() - this.offset;
        if (available == 0) {
            if (this.parser.hasNext()) {
                try {
                    XMLEvent event = this.parser.nextEvent();
                    this.processEvent(event);
                }
                catch (IOException | RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                available = this.buffer.length() - this.offset;
            } else {
                count = -1;
            }
        }
        if (available > 0) {
            count = Math.min(destCount, available);
            this.buffer.getChars(this.offset, this.offset + count, destBuffer, destOffset);
            this.offset += count;
            if (this.offset == this.buffer.length()) {
                this.offset = 0;
                this.buffer.setLength(0);
            }
        }
        return count;
    }

    private void processEvent(XMLEvent event) throws ParserConfigurationException, XPathExpressionException, IOException, XMLStreamException {
        int type = event.getEventType();
        switch (type) {
            case 7: {
                this.processStartDocument((StartDocument)event);
                break;
            }
            case 8: {
                this.processEndDocument();
                break;
            }
            case 1: {
                if (this.parser.peek().getEventType() == 2) {
                    this.isEmptyElement = true;
                }
                this.processStartElement(event.asStartElement());
                break;
            }
            case 2: {
                this.processEndElement(event.asEndElement());
                this.isEmptyElement = false;
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                this.processCharacters(event.asCharacters());
                break;
            }
            case 5: {
                this.processComment((Comment)event);
                break;
            }
            default: {
                throw new IllegalStateException(Integer.toString(type));
            }
        }
    }

    private void processStartDocument(StartDocument event) throws ParserConfigurationException {
        this.document = XmlUtils.createDocument((boolean)false);
        this.pushLevel(null, this.document, this.document, this.config);
        this.writer.write("<?xml");
        String s = event.getVersion();
        if (s == null) {
            s = DEFAULT_XML_VERSION;
        }
        this.writer.write(" version=\"");
        this.writer.write(s);
        this.writer.write("\"");
        s = event.getCharacterEncodingScheme();
        if (s != null) {
            this.writer.write(" encoding=\"");
            this.writer.write(s);
            this.writer.write("\"");
        }
        this.writer.write(" standalone=\"");
        this.writer.write(event.isStandalone() ? "yes" : "no");
        this.writer.write("\"");
        this.writer.write("?>");
    }

    private void processEndDocument() {
        this.stack.clear();
        this.document = null;
    }

    private void processStartElement(StartElement event) throws XPathExpressionException {
        Element element = this.bufferElement(event);
        Level parent = this.stack.peek();
        parent.node.appendChild(element);
        if (this.currentlyBuffering()) {
            this.pushLevel(parent, element, parent.scopeNode, parent.scopeConfig);
            this.bufferAttributes(event, element);
        } else {
            UrlRewriteFilterPathDescriptor descriptor = this.pickFirstMatchingPath(parent);
            if (descriptor != null) {
                if (descriptor instanceof UrlRewriteFilterBufferDescriptor) {
                    this.pushLevel(parent, element, element, (UrlRewriteFilterBufferDescriptor)descriptor);
                    this.bufferAttributes(event, element);
                } else if (descriptor instanceof UrlRewriteFilterScopeDescriptor) {
                    this.pushLevel(parent, element, element, (UrlRewriteFilterScopeDescriptor)descriptor);
                    this.streamElement(event, element);
                } else {
                    this.pushLevel(parent, element, parent.scopeNode, parent.scopeConfig);
                    this.streamElement(event, element);
                }
            } else {
                this.pushLevel(parent, element, parent.scopeNode, parent.scopeConfig);
                this.streamElement(event, element);
            }
        }
    }

    private void processEndElement(EndElement event) throws XPathExpressionException, IOException {
        boolean buffering = this.currentlyBuffering();
        Level child = this.stack.pop();
        if (buffering) {
            if (child.node == child.scopeNode) {
                this.processBufferedElement(child);
            }
        } else {
            if (!this.isEmptyElement) {
                QName n = event.getName();
                this.writer.write("</");
                String p = n.getPrefix();
                if (p != null && !p.isEmpty()) {
                    this.writer.write(p);
                    this.writer.write(":");
                }
                this.writer.write(n.getLocalPart());
                this.writer.write(">");
            }
            child.node.getParentNode().removeChild(child.node);
        }
    }

    private Element bufferElement(StartElement event) {
        Element element;
        QName qname = event.getName();
        String prefix = qname.getPrefix();
        String uri = qname.getNamespaceURI();
        if (uri == null || uri.isEmpty()) {
            element = this.document.createElement(qname.getLocalPart());
        } else {
            element = this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            if (prefix != null && !prefix.isEmpty()) {
                element.setPrefix(prefix);
            }
        }
        this.bufferNamespaces(event, element);
        return element;
    }

    private void bufferNamespaces(StartElement event, Element element) {
        Iterator<Namespace> namespaces = event.getNamespaces();
        while (namespaces.hasNext()) {
            Namespace namespace = namespaces.next();
            if (namespace.isDefaultNamespaceDeclaration()) {
                element.setAttribute("xmlns", namespace.getNamespaceURI());
                continue;
            }
            element.setAttribute("xmlns:" + namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    private void streamElement(StartElement event, Element element) throws XPathExpressionException {
        this.writer.write("<");
        QName qname = event.getName();
        String prefix = event.getName().getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            this.writer.write(prefix);
            this.writer.write(":");
        }
        this.writer.write(qname.getLocalPart());
        this.streamNamespaces(event);
        this.streamAttributes(event, element);
        if (this.isEmptyElement) {
            this.writer.write("/>");
        } else {
            this.writer.write(">");
        }
    }

    private void processBufferedElement(Level level, UrlRewriteFilterGroupDescriptor config) throws XPathExpressionException {
        for (UrlRewriteFilterPathDescriptor selector : config.getSelectors()) {
            Object node;
            XPathExpression path;
            if (selector instanceof UrlRewriteFilterApplyDescriptor) {
                String value;
                path = selector.compiledPath(XPATH_COMPILER);
                node = path.evaluate(level.scopeNode, XPathConstants.NODE);
                if (node == null) continue;
                UrlRewriteFilterApplyDescriptor apply = (UrlRewriteFilterApplyDescriptor)selector;
                if (node instanceof Element) {
                    Element element = (Element)node;
                    value = element.getTextContent();
                    value = this.filterText(this.extractQName(element), value, apply.rule());
                    element.setTextContent(value);
                    continue;
                }
                if (node instanceof Text) {
                    Text text = (Text)node;
                    value = text.getWholeText();
                    value = this.filterText(this.extractQName(text.getParentNode()), value, apply.rule());
                    text.replaceWholeText(value);
                    continue;
                }
                if (node instanceof Attr) {
                    Attr attr = (Attr)node;
                    value = attr.getValue();
                    value = this.filterAttribute(this.extractQName(attr.getOwnerElement()), this.extractQName(attr), value, apply.rule());
                    attr.setValue(value);
                    continue;
                }
                throw new IllegalArgumentException(RES.unexpectedSelectedNodeType(node));
            }
            if (selector instanceof UrlRewriteFilterDetectDescriptor) {
                String value;
                path = selector.compiledPath(XPATH_COMPILER);
                node = path.evaluate(level.scopeNode, XPathConstants.NODE);
                if (node == null) continue;
                UrlRewriteFilterDetectDescriptor detect = (UrlRewriteFilterDetectDescriptor)selector;
                if (node instanceof Element) {
                    Element element = (Element)node;
                    value = element.getTextContent();
                } else if (node instanceof Text) {
                    Text text = (Text)node;
                    value = text.getWholeText();
                } else if (node instanceof Attr) {
                    Attr attr = (Attr)node;
                    value = attr.getValue();
                } else {
                    throw new IllegalArgumentException(RES.unexpectedSelectedNodeType(node));
                }
                if (!detect.compiledValue(REGEX_COMPILER).matcher(value).matches()) continue;
                this.processBufferedElement(level, detect);
                continue;
            }
            throw new IllegalArgumentException(RES.unexpectedRewritePathSelector(selector));
        }
    }

    private void processBufferedElement(Level level) throws XPathExpressionException, IOException {
        this.processBufferedElement(level, level.scopeConfig);
        XmlFilterReader.writeBufferedElement(level.node, this.writer);
    }

    private QName extractQName(Node node) {
        String localName = node.getLocalName();
        QName qname = localName == null ? new QName(node.getNodeName()) : (node.getPrefix() == null ? new QName(node.getNamespaceURI(), localName) : new QName(node.getNamespaceURI(), localName, node.getPrefix()));
        return qname;
    }

    private void bufferAttributes(StartElement event, Element element) {
        Iterator<Attribute> attributes = event.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            this.bufferAttribute(element, attribute);
        }
    }

    private Attr bufferAttribute(Element element, Attribute attribute) {
        Attr node;
        QName name = attribute.getName();
        String prefix = name.getPrefix();
        String uri = name.getNamespaceURI();
        if (uri == null || uri.isEmpty()) {
            node = this.document.createAttribute(name.getLocalPart());
            element.setAttributeNode(node);
        } else {
            node = this.document.createAttributeNS(uri, name.getLocalPart());
            if (prefix != null && !prefix.isEmpty()) {
                node.setPrefix(prefix);
            }
            element.setAttributeNodeNS(node);
        }
        node.setTextContent(attribute.getValue());
        return node;
    }

    private void streamNamespaces(StartElement event) {
        Iterator<Namespace> i = event.getNamespaces();
        while (i.hasNext()) {
            Namespace ns = i.next();
            this.writer.write(" xmlns");
            if (!ns.isDefaultNamespaceDeclaration()) {
                this.writer.write(":");
                this.writer.write(ns.getPrefix());
            }
            this.writer.write("=\"");
            this.writer.write(ns.getNamespaceURI());
            this.writer.write("\"");
        }
    }

    private void streamAttributes(StartElement event, Element element) throws XPathExpressionException {
        Iterator<Attribute> i = event.getAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            this.streamAttribute(element, attribute);
        }
    }

    private void streamAttribute(Element element, Attribute attribute) throws XPathExpressionException {
        Attr node;
        QName name = attribute.getName();
        String prefix = name.getPrefix();
        String uri = name.getNamespaceURI();
        if (uri == null || uri.isEmpty()) {
            node = this.document.createAttribute(name.getLocalPart());
            element.setAttributeNode(node);
        } else {
            node = this.document.createAttributeNS(uri, name.getLocalPart());
            if (prefix != null && !prefix.isEmpty()) {
                node.setPrefix(prefix);
            }
            element.setAttributeNodeNS(node);
        }
        String value = attribute.getValue();
        Level level = this.stack.peek();
        if (level.scopeConfig == null || level.scopeConfig.getSelectors().isEmpty()) {
            value = this.filterAttribute(null, attribute.getName(), value, null);
            node.setValue(value);
        } else {
            UrlRewriteFilterPathDescriptor path = this.pickFirstMatchingPath(level);
            if (path instanceof UrlRewriteFilterApplyDescriptor) {
                String rule = ((UrlRewriteFilterApplyDescriptor)path).rule();
                value = this.filterAttribute(null, attribute.getName(), value, rule);
                node.setValue(value);
            }
        }
        if (prefix == null || prefix.isEmpty()) {
            this.writer.write(" ");
            this.writer.write(name.getLocalPart());
        } else {
            this.writer.write(" ");
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(name.getLocalPart());
        }
        this.writer.write("=\"");
        this.writer.write(value);
        this.writer.write("\"");
        element.removeAttributeNode(node);
    }

    private void processCharacters(Characters event) {
        Level level = this.stack.peek();
        Node node = this.stack.peek().node;
        if (event.isCData()) {
            node.appendChild(this.document.createCDATASection(event.getData()));
        } else {
            node.appendChild(this.document.createTextNode(event.getData()));
        }
        if (!this.currentlyBuffering()) {
            String value = event.getData();
            if (!event.isWhiteSpace()) {
                if (level.scopeConfig == null || level.scopeConfig.getSelectors().isEmpty()) {
                    value = this.filterText(this.extractQName(node), value, null);
                } else {
                    UrlRewriteFilterPathDescriptor path = this.pickFirstMatchingPath(level);
                    if (path instanceof UrlRewriteFilterApplyDescriptor) {
                        String rule = ((UrlRewriteFilterApplyDescriptor)path).rule();
                        value = this.filterText(this.extractQName(node), value, rule);
                    }
                }
            }
            if (event.isCData()) {
                this.writer.write("<![CDATA[");
                this.writer.write(value);
                this.writer.write("]]>");
            } else {
                this.writer.write(StringEscapeUtils.escapeXml11((String)value));
            }
        }
    }

    private void processComment(Comment event) {
        if (this.currentlyBuffering()) {
            this.stack.peek().node.appendChild(this.document.createComment(event.getText()));
        } else {
            this.writer.write("<!--");
            this.writer.write(event.getText());
            this.writer.write("-->");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.parser.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.reader.close();
        this.writer.close();
        this.stack.clear();
    }

    protected UrlRewriteFilterPathDescriptor pickFirstMatchingPath(Level level) {
        UrlRewriteFilterPathDescriptor match = null;
        if (level.scopeConfig != null) {
            for (UrlRewriteFilterPathDescriptor selector : level.scopeConfig.getSelectors()) {
                try {
                    XPathExpression path = selector.compiledPath(XPATH_COMPILER);
                    Object node = path.evaluate(level.scopeNode, XPathConstants.NODE);
                    if (node == null) continue;
                    match = selector;
                    break;
                }
                catch (XPathExpressionException e) {
                    throw new IllegalArgumentException(selector.path(), e);
                }
            }
        }
        return match;
    }

    private boolean currentlyBuffering() {
        return this.stack.peek().buffered;
    }

    private Level pushLevel(Level parent, Node node, Node scopeNode, UrlRewriteFilterGroupDescriptor scopeConfig) {
        Level level = new Level(parent, node, scopeNode, scopeConfig);
        this.stack.push(level);
        return level;
    }

    private static void writeBufferedElement(Node node, Writer writer) throws IOException {
        try {
            Transformer t = XmlUtils.getTransformer((boolean)false, (boolean)false, (int)0, (boolean)true);
            t.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private static class RegexCompiler
    implements UrlRewriteFilterPathDescriptor.Compiler<Pattern> {
        private RegexCompiler() {
        }

        @Override
        public Pattern compile(String expression, Pattern compiled) {
            if (compiled != null) {
                return compiled;
            }
            return Pattern.compile(expression);
        }
    }

    private static class XmlPathCompiler
    implements UrlRewriteFilterPathDescriptor.Compiler<XPathExpression> {
        private static final XPathFactory xpathFactory = XmlPathCompiler.getXpathFactory();

        private XmlPathCompiler() {
        }

        private static synchronized XPathFactory getXpathFactory() {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            try {
                xPathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
                // empty catch block
            }
            return xPathFactory;
        }

        private synchronized XPathExpression getXPathExpression(String expression) {
            try {
                return xpathFactory.newXPath().compile(expression);
            }
            catch (XPathExpressionException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public XPathExpression compile(String expression, XPathExpression compiled) {
            if (compiled != null) {
                return compiled;
            }
            return this.getXPathExpression(expression);
        }
    }

    private static class Level {
        private Node node;
        private UrlRewriteFilterGroupDescriptor scopeConfig;
        private Node scopeNode;
        private boolean buffered;

        Level(Level parent, Node node, Node scopeNode, UrlRewriteFilterGroupDescriptor scopeConfig) {
            this.node = node;
            this.scopeConfig = scopeConfig;
            this.scopeNode = scopeNode;
            this.buffered = parent != null && parent.buffered || scopeConfig instanceof UrlRewriteFilterBufferDescriptor;
        }
    }
}

