/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Version;

public class Topology {
    private URI uri;
    private String name;
    private String defaultServicePath;
    private long timestamp;
    private boolean isGenerated;
    public List<Provider> providerList = new ArrayList<Provider>();
    private Map<String, Map<String, Provider>> providerMap = new HashMap<String, Map<String, Provider>>();
    public List<Service> services = new ArrayList<Service>();
    private MultiKeyMap serviceMap;
    private List<Application> applications = new ArrayList<Application>();
    private Map<String, Application> applicationMap = new HashMap<String, Application>();

    public Topology() {
        this.serviceMap = MultiKeyMap.decorate((AbstractHashedMap)new HashedMap());
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDefaultServicePath() {
        return this.defaultServicePath;
    }

    public void setDefaultServicePath(String servicePath) {
        this.defaultServicePath = servicePath;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public Collection<Service> getServices() {
        return this.services;
    }

    public Service getService(String role, String name, Version version) {
        return (Service)this.serviceMap.get((Object)role, (Object)name, (Object)version);
    }

    public void addService(Service service) {
        this.services.add(service);
        this.serviceMap.put((Object)service.getRole(), (Object)service.getName(), (Object)service.getVersion(), (Object)service);
    }

    public Collection<Application> getApplications() {
        return this.applications;
    }

    private static String fixApplicationUrl(String url) {
        if (url == null) {
            url = "/";
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url;
    }

    public Application getApplication(String url) {
        return this.applicationMap.get(Topology.fixApplicationUrl(url));
    }

    public void addApplication(Application application) {
        this.applications.add(application);
        List<String> urls = application.getUrls();
        if (urls == null || urls.isEmpty()) {
            this.applicationMap.put(Topology.fixApplicationUrl(application.getName()), application);
        } else {
            for (String url : application.getUrls()) {
                this.applicationMap.put(Topology.fixApplicationUrl(url), application);
            }
        }
    }

    public Collection<Provider> getProviders() {
        return this.providerList;
    }

    public Provider getProvider(String role, String name) {
        Provider provider = null;
        Map<String, Provider> nameMap = this.providerMap.get(role);
        if (nameMap != null) {
            provider = name != null ? nameMap.get(name) : (Provider)nameMap.values().toArray()[0];
        }
        return provider;
    }

    public void addProvider(Provider provider) {
        this.providerList.add(provider);
        String role = provider.getRole();
        Map<String, Provider> nameMap = this.providerMap.get(role);
        if (nameMap == null) {
            nameMap = new HashMap<String, Provider>();
            this.providerMap.put(role, nameMap);
        }
        nameMap.put(provider.getName(), provider);
    }
}

