(function() {
  var escope, expect, harmony;

  expect = require('chai').expect;

  harmony = require('../third_party/esprima');

  escope = require('..');

  describe('ES6 destructuring assignments', function() {
    it('Pattern in var in ForInStatement', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    for (var [a, b, c] in array);\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('array');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(4);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('a');
      expect(scope.variables[2].name).to.be.equal('b');
      expect(scope.variables[3].name).to.be.equal('c');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('a');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[1].identifier.name).to.be.equal('b');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to.be.equal(scope.variables[2]);
      expect(scope.references[2].identifier.name).to.be.equal('c');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to.be.equal(scope.variables[3]);
      expect(scope.references[3].identifier.name).to.be.equal('array');
      return expect(scope.references[3].isWrite()).to.be["false"];
    });
    it('ArrayPattern in var', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    var [a, b, c] = array;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('array');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(4);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('a');
      expect(scope.variables[2].name).to.be.equal('b');
      expect(scope.variables[3].name).to.be.equal('c');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('a');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[1].identifier.name).to.be.equal('b');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to.be.equal(scope.variables[2]);
      expect(scope.references[2].identifier.name).to.be.equal('c');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to.be.equal(scope.variables[3]);
      expect(scope.references[3].identifier.name).to.be.equal('array');
      return expect(scope.references[3].isWrite()).to.be["false"];
    });
    it('SpreadElement in var', function() {
      var ast, globalScope, index, name, scope, scopeManager, _i, _j, _len, _len1, _ref, _ref1;
      ast = harmony.parse("(function () {\n    var [a, b, ...rest] = array;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('array');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(4);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('a');
      expect(scope.variables[2].name).to.be.equal('b');
      expect(scope.variables[3].name).to.be.equal('rest');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('a');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[1].identifier.name).to.be.equal('b');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to.be.equal(scope.variables[2]);
      expect(scope.references[2].identifier.name).to.be.equal('rest');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to.be.equal(scope.variables[3]);
      expect(scope.references[3].identifier.name).to.be.equal('array');
      expect(scope.references[3].isWrite()).to.be["false"];
      ast = harmony.parse("(function () {\n    var [a, b, ...[c, d, ...rest]] = array;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('array');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(6);
      _ref = ['arguments', 'a', 'b', 'c', 'd', 'rest'];
      for (index = _i = 0, _len = _ref.length; _i < _len; index = ++_i) {
        name = _ref[index];
        expect(scope.variables[index].name).to.be.equal(name);
      }
      expect(scope.references).to.have.length(6);
      _ref1 = ['a', 'b', 'c', 'd', 'rest'];
      for (index = _j = 0, _len1 = _ref1.length; _j < _len1; index = ++_j) {
        name = _ref1[index];
        expect(scope.references[index].identifier.name).to.be.equal(name);
        expect(scope.references[index].isWrite()).to.be["true"];
        expect(scope.references[index].partial).to.be["true"];
      }
      expect(scope.references[5].identifier.name).to.be.equal('array');
      return expect(scope.references[5].isWrite()).to.be["false"];
    });
    it('ObjectPattern in var', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    var {\n        shorthand,\n        key: value,\n        hello: {\n            world\n        }\n    } = object;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('object');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(4);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('shorthand');
      expect(scope.variables[2].name).to.be.equal('value');
      expect(scope.variables[3].name).to.be.equal('world');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('shorthand');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to.be.equal(scope.variables[1]);
      expect(scope.references[1].identifier.name).to.be.equal('value');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to.be.equal(scope.variables[2]);
      expect(scope.references[2].identifier.name).to.be.equal('world');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to.be.equal(scope.variables[3]);
      expect(scope.references[3].identifier.name).to.be.equal('object');
      return expect(scope.references[3].isWrite()).to.be["false"];
    });
    it('complex pattern in var', function() {
      var ast, globalScope, index, name, scope, scopeManager, _i, _j, _len, _len1, _ref, _ref1;
      ast = harmony.parse("(function () {\n    var {\n        shorthand,\n        key: [ a, b, c, d, e ],\n        hello: {\n            world\n        }\n    } = object;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('object');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(8);
      _ref = ['arguments', 'shorthand', 'a', 'b', 'c', 'd', 'e', 'world'];
      for (index = _i = 0, _len = _ref.length; _i < _len; index = ++_i) {
        name = _ref[index];
        expect(scope.variables[index].name).to.be.equal(name);
      }
      expect(scope.references).to.have.length(8);
      _ref1 = ['shorthand', 'a', 'b', 'c', 'd', 'e', 'world'];
      for (index = _j = 0, _len1 = _ref1.length; _j < _len1; index = ++_j) {
        name = _ref1[index];
        expect(scope.references[index].identifier.name).to.be.equal(name);
        expect(scope.references[index].isWrite()).to.be["true"];
        expect(scope.references[index].partial).to.be["true"];
      }
      expect(scope.references[7].identifier.name).to.be.equal('object');
      return expect(scope.references[7].isWrite()).to.be["false"];
    });
    it('ArrayPattern in AssignmentExpression', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    [a, b, c] = array;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(4);
      expect(scope.implicit.left.map((function(_this) {
        return function(ref) {
          return ref.identifier.name;
        };
      })(this))).to.deep.equal(['a', 'b', 'c', 'array']);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('a');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to.be["null"];
      expect(scope.references[1].identifier.name).to.be.equal('b');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to.be["null"];
      expect(scope.references[2].identifier.name).to.be.equal('c');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to.be["null"];
      expect(scope.references[3].identifier.name).to.be.equal('array');
      return expect(scope.references[3].isWrite()).to.be["false"];
    });
    it('SpreadElement in AssignmentExpression', function() {
      var ast, globalScope, index, name, scope, scopeManager, _i, _len, _ref;
      ast = harmony.parse("(function () {\n    [a, b, ...rest] = array;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(4);
      expect(scope.implicit.left.map((function(_this) {
        return function(ref) {
          return ref.identifier.name;
        };
      })(this))).to.deep.equal(['a', 'b', 'rest', 'array']);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('a');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to.be["null"];
      expect(scope.references[1].identifier.name).to.be.equal('b');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to.be["null"];
      expect(scope.references[2].identifier.name).to.be.equal('rest');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to.be["null"];
      expect(scope.references[3].identifier.name).to.be.equal('array');
      expect(scope.references[3].isWrite()).to.be["false"];
      ast = harmony.parse("(function () {\n    [a, b, ...[c, d, ...rest]] = array;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(6);
      expect(scope.implicit.left.map((function(_this) {
        return function(ref) {
          return ref.identifier.name;
        };
      })(this))).to.deep.equal(['a', 'b', 'c', 'd', 'rest', 'array']);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.references).to.have.length(6);
      _ref = ['a', 'b', 'c', 'd', 'rest'];
      for (index = _i = 0, _len = _ref.length; _i < _len; index = ++_i) {
        name = _ref[index];
        expect(scope.references[index].identifier.name).to.be.equal(name);
        expect(scope.references[index].isWrite()).to.be["true"];
        expect(scope.references[index].partial).to.be["true"];
        expect(scope.references[index].resolved).to.be["null"];
      }
      expect(scope.references[5].identifier.name).to.be.equal('array');
      return expect(scope.references[5].isWrite()).to.be["false"];
    });
    it('ObjectPattern in AssignmentExpression', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function () {\n    ({\n        shorthand,\n        key: value,\n        hello: {\n            world\n        }\n    }) = object;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(4);
      expect(scope.implicit.left.map((function(_this) {
        return function(ref) {
          return ref.identifier.name;
        };
      })(this))).to.deep.equal(['shorthand', 'value', 'world', 'object']);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.references).to.have.length(4);
      expect(scope.references[0].identifier.name).to.be.equal('shorthand');
      expect(scope.references[0].isWrite()).to.be["true"];
      expect(scope.references[0].partial).to.be["true"];
      expect(scope.references[0].resolved).to["null"];
      expect(scope.references[1].identifier.name).to.be.equal('value');
      expect(scope.references[1].isWrite()).to.be["true"];
      expect(scope.references[1].partial).to.be["true"];
      expect(scope.references[1].resolved).to["null"];
      expect(scope.references[2].identifier.name).to.be.equal('world');
      expect(scope.references[2].isWrite()).to.be["true"];
      expect(scope.references[2].partial).to.be["true"];
      expect(scope.references[2].resolved).to["null"];
      expect(scope.references[3].identifier.name).to.be.equal('object');
      return expect(scope.references[3].isWrite()).to.be["false"];
    });
    it('complex pattern in AssignmentExpression', function() {
      var ast, globalScope, index, name, scope, scopeManager, _i, _len, _ref;
      ast = harmony.parse("(function () {\n    ({\n        shorthand,\n        key: [ a, b, c, d, e ],\n        hello: {\n            world\n        }\n    }) = object;\n}());");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(0);
      expect(scope.implicit.left).to.have.length(8);
      expect(scope.implicit.left.map((function(_this) {
        return function(ref) {
          return ref.identifier.name;
        };
      })(this))).to.deep.equal(['shorthand', 'a', 'b', 'c', 'd', 'e', 'world', 'object']);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.references).to.have.length(8);
      _ref = ['shorthand', 'a', 'b', 'c', 'd', 'e', 'world'];
      for (index = _i = 0, _len = _ref.length; _i < _len; index = ++_i) {
        name = _ref[index];
        expect(scope.references[index].identifier.name).to.be.equal(name);
        expect(scope.references[index].isWrite()).to.be["true"];
        expect(scope.references[index].partial).to.be["true"];
      }
      expect(scope.references[7].identifier.name).to.be.equal('object');
      return expect(scope.references[7].isWrite()).to.be["false"];
    });
    it('ArrayPattern in parameters', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function ([a, b, c]) {\n}(array));");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('array');
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('array');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(4);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('a');
      expect(scope.variables[2].name).to.be.equal('b');
      expect(scope.variables[3].name).to.be.equal('c');
      return expect(scope.references).to.have.length(0);
    });
    it('SpreadElement in parameters', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function ([a, b, ...rest], ...rest2) {\n}(array));");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('array');
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('array');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(5);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('a');
      expect(scope.variables[2].name).to.be.equal('b');
      expect(scope.variables[3].name).to.be.equal('rest');
      expect(scope.variables[3].defs[0].rest).to.be["false"];
      expect(scope.variables[4].name).to.be.equal('rest2');
      expect(scope.variables[4].defs[0].rest).to.be["true"];
      return expect(scope.references).to.have.length(0);
    });
    it('ObjectPattern in parameters', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("(function ({\n        shorthand,\n        key: value,\n        hello: {\n            world\n        }\n    }) {\n}(object));");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('object');
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('object');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(4);
      expect(scope.variables[0].name).to.be.equal('arguments');
      expect(scope.variables[1].name).to.be.equal('shorthand');
      expect(scope.variables[2].name).to.be.equal('value');
      expect(scope.variables[3].name).to.be.equal('world');
      return expect(scope.references).to.have.length(0);
    });
    return it('complex pattern in parameters', function() {
      var ast, globalScope, index, name, scope, scopeManager, _i, _len, _ref;
      ast = harmony.parse("(function ({\n        shorthand,\n        key: [ a, b, c, d, e ],\n        hello: {\n            world\n        }\n    }) {\n}(object));");
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6
      });
      expect(scopeManager.scopes).to.have.length(2);
      scope = scopeManager.scopes[0];
      globalScope = scope;
      expect(scope.type).to.be.equal('global');
      expect(scope.variables).to.have.length(0);
      expect(scope.references).to.have.length(1);
      expect(scope.references[0].identifier.name).to.be.equal('object');
      expect(scope.implicit.left).to.have.length(1);
      expect(scope.implicit.left[0].identifier.name).to.be.equal('object');
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('function');
      expect(scope.variables).to.have.length(8);
      _ref = ['arguments', 'shorthand', 'a', 'b', 'c', 'd', 'e', 'world'];
      for (index = _i = 0, _len = _ref.length; _i < _len; index = ++_i) {
        name = _ref[index];
        expect(scope.variables[index].name).to.be.equal(name);
      }
      return expect(scope.references).to.have.length(0);
    });
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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