/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class FsUsage
extends FsCommand {
    private boolean humanReadable = false;
    private TableBuilder usagesTable;

    FsUsage() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Df.class, "-df");
        factory.addClass(Du.class, "-du");
        factory.addClass(Dus.class, "-dus");
    }

    protected String formatSize(long size) {
        return this.humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    public TableBuilder getUsagesTable() {
        return this.usagesTable;
    }

    public void setUsagesTable(TableBuilder usagesTable) {
        this.usagesTable = usagesTable;
    }

    public void setHumanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
    }

    private static class TableBuilder {
        protected boolean hasHeader = false;
        protected List<String[]> rows = new ArrayList<String[]>();
        protected int[] widths;
        protected boolean[] rightAlign;
        private boolean[] hide;

        public TableBuilder(int columns) {
            this.widths = new int[columns];
            this.rightAlign = new boolean[columns];
            this.hide = new boolean[columns];
        }

        public TableBuilder(Object ... headers) {
            this(headers.length);
            this.addRow(headers);
            this.hasHeader = true;
        }

        public void setRightAlign(int ... indexes) {
            for (int i : indexes) {
                this.rightAlign[i] = true;
            }
        }

        public void setColumnHide(int columnIndex, boolean hideCol) {
            this.hide[columnIndex] = hideCol;
        }

        public void addRow(Object ... objects) {
            String[] row = new String[this.widths.length];
            for (int col = 0; col < this.widths.length; ++col) {
                row[col] = String.valueOf(objects[col]);
                this.widths[col] = Math.max(this.widths[col], row[col].length());
            }
            this.rows.add(row);
        }

        public void printToStream(PrintStream out) {
            if (this.isEmpty()) {
                return;
            }
            StringBuilder fmt = new StringBuilder();
            for (int i = 0; i < this.widths.length; ++i) {
                if (this.hide[i]) continue;
                if (fmt.length() != 0) {
                    fmt.append("  ");
                }
                if (this.rightAlign[i]) {
                    fmt.append("%" + this.widths[i] + "s");
                    continue;
                }
                if (i != this.widths.length - 1) {
                    fmt.append("%-" + this.widths[i] + "s");
                    continue;
                }
                fmt.append("%s");
            }
            for (Object[] objectArray : this.rows) {
                out.println(String.format(fmt.toString(), objectArray));
            }
        }

        public int size() {
            return this.rows.size() - (this.hasHeader ? 1 : 0);
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    public static class Dus
    extends Du {
        public static final String NAME = "dus";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-s");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "du -s";
        }
    }

    public static class Du
    extends FsUsage {
        public static final String NAME = "du";
        public static final String USAGE = "[-s] [-h] [-v] [-x] <path> ...";
        public static final String DESCRIPTION = "Show the amount of space, in bytes, used by the files that match the specified file pattern. The following flags are optional:\n-s: Rather than showing the size of each individual file that matches the pattern, shows the total (summary) size.\n-h: Formats the sizes of files in a human-readable fashion rather than a number of bytes.\n-v: option displays a header line.\n-x: Excludes snapshots from being counted.\n\nNote that, even without the -s option, this only shows size summaries one level deep into a directory.\n\nThe output is in the form \n\tsize\tdisk space consumed\tname(full path)\n";
        protected boolean summary = false;
        private boolean showHeaderLine = false;
        private boolean excludeSnapshots = false;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "h", "s", "v", "x");
            cf.parse(args);
            this.setHumanReadable(cf.getOpt("h"));
            this.summary = cf.getOpt("s");
            this.showHeaderLine = cf.getOpt("v");
            this.excludeSnapshots = cf.getOpt("x");
            if (args.isEmpty()) {
                args.add(".");
            }
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            if (this.showHeaderLine) {
                this.setUsagesTable(new TableBuilder("SIZE", "DISK_SPACE_CONSUMED_WITH_ALL_REPLICAS", "FULL_PATH_NAME"));
            } else {
                this.setUsagesTable(new TableBuilder(3));
            }
            super.processArguments(args);
            if (!this.getUsagesTable().isEmpty()) {
                this.getUsagesTable().printToStream(this.out);
            }
        }

        @Override
        protected void processPathArgument(PathData item) throws IOException {
            if (!this.summary && item.stat.isDirectory()) {
                this.recursePath(item);
            } else {
                super.processPathArgument(item);
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            ContentSummary contentSummary = item.fs.getContentSummary(item.path);
            long length = contentSummary.getLength();
            long spaceConsumed = contentSummary.getSpaceConsumed();
            if (this.excludeSnapshots) {
                length -= contentSummary.getSnapshotLength();
                spaceConsumed -= contentSummary.getSnapshotSpaceConsumed();
            }
            this.getUsagesTable().addRow(this.formatSize(length), this.formatSize(spaceConsumed), item);
        }
    }

    public static class Df
    extends FsUsage {
        public static final String NAME = "df";
        public static final String USAGE = "[-h] [<path> ...]";
        public static final String DESCRIPTION = "Shows the capacity, free and used space of the filesystem. If the filesystem has multiple partitions, and no path to a particular partition is specified, then the status of the root partitions will be shown.\n-h: Formats the sizes of files in a human-readable fashion rather than a number of bytes.";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "h");
            cf.parse(args);
            this.setHumanReadable(cf.getOpt("h"));
            if (args.isEmpty()) {
                args.add("/");
            }
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            this.setUsagesTable(new TableBuilder("Filesystem", "Size", "Used", "Available", "Use%", "Mounted on"));
            this.getUsagesTable().setRightAlign(1, 2, 3, 4);
            super.processArguments(args);
            if (!this.getUsagesTable().isEmpty()) {
                this.getUsagesTable().printToStream(this.out);
            }
        }

        private void addToUsagesTable(URI uri, FsStatus fsStatus, String mountedOnPath) {
            long size = fsStatus.getCapacity();
            long used = fsStatus.getUsed();
            long free = fsStatus.getRemaining();
            this.getUsagesTable().addRow(uri, this.formatSize(size), this.formatSize(used), this.formatSize(free), StringUtils.formatPercent((double)used / (double)size, 0), mountedOnPath);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (ViewFileSystemUtil.isViewFileSystem(item.fs)) {
                ViewFileSystem viewFileSystem = (ViewFileSystem)item.fs;
                Map<ViewFileSystem.MountPoint, FsStatus> fsStatusMap = ViewFileSystemUtil.getStatus(viewFileSystem, item.path);
                for (Map.Entry<ViewFileSystem.MountPoint, FsStatus> entry : fsStatusMap.entrySet()) {
                    ViewFileSystem.MountPoint viewFsMountPoint = entry.getKey();
                    FsStatus fsStatus = entry.getValue();
                    URI[] mountPointFileSystemURIs = viewFsMountPoint.getTargetFileSystemURIs();
                    this.addToUsagesTable(mountPointFileSystemURIs[0], fsStatus, viewFsMountPoint.getMountedOnPath().toString());
                }
            } else {
                this.getUsagesTable().setColumnHide(5, true);
                FsStatus fsStatus = item.fs.getStatus(item.path);
                this.addToUsagesTable(item.fs.getUri(), fsStatus, "/");
            }
        }
    }
}

