/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.SearchRequest;

public class SearchRequestContainer {
    private SearchRequest searchRequest;
    private long sizeLimit;
    private int count;
    private long timeLimit;
    private long initialTime;
    private Cursor<Entry> cursor;

    public SearchRequestContainer(SearchRequest searchRequest, Cursor<Entry> cursor) {
        this.searchRequest = searchRequest;
        this.cursor = cursor;
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = (long)searchRequest.getTimeLimit() * 1000L;
        this.count = 0;
        this.initialTime = System.currentTimeMillis();
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isSizeLimitReached() {
        return this.sizeLimit > 0L && (long)this.count >= this.sizeLimit;
    }

    public void increment() {
        ++this.count;
    }

    public int getTimeLimit() {
        return (int)(this.timeLimit / 1000L);
    }

    public boolean isTimeLimitReached() {
        long currentTime = System.currentTimeMillis();
        return this.timeLimit > 0L && this.initialTime + this.timeLimit < currentTime;
    }

    public long getInitialTime() {
        return this.initialTime;
    }

    public Cursor<Entry> getCursor() {
        return this.cursor;
    }

    public String toString() {
        long elapsed = System.currentTimeMillis() - this.initialTime;
        return "SRContainer : <" + this.searchRequest.getMessageId() + ", nbSent : " + this.count + ", elapsed : " + elapsed + ">";
    }
}

