/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.auth.Authentication;
import com.cloudera.api.swagger.client.auth.HttpBasicAuth;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.auth.AuthUtils;
import org.apache.knox.gateway.topology.discovery.cm.auth.SpnegoAuthInterceptor;
import org.apache.knox.gateway.util.TruststoreSSLContextUtils;

public class DiscoveryApiClient
extends ApiClient {
    private ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private boolean isKerberos;
    private ServiceDiscoveryConfig config;

    public DiscoveryApiClient(ServiceDiscoveryConfig discoveryConfig, AliasService aliasService, KeystoreService keystoreService) {
        this.config = discoveryConfig;
        this.configure(aliasService, keystoreService);
    }

    boolean isKerberos() {
        return this.isKerberos;
    }

    private void configure(AliasService aliasService, KeystoreService keystoreService) {
        Subject subject;
        String apiAddress = this.config.getAddress();
        apiAddress = apiAddress + (apiAddress.endsWith("/") ? "api/v32" : "/api/v32");
        this.setBasePath(apiAddress);
        String username = this.config.getUser();
        String passwordAlias = this.config.getPasswordAlias();
        String password = null;
        if (username == null) {
            if (aliasService != null) {
                try {
                    char[] defaultUser = aliasService.getPasswordFromAliasForGateway("cm.discovery.user");
                    if (defaultUser != null) {
                        username = new String(defaultUser);
                    }
                }
                catch (AliasServiceException e) {
                    this.log.aliasServiceUserError("cm.discovery.user", e.getLocalizedMessage());
                }
            }
            if (username == null) {
                this.log.aliasServiceUserNotFound();
                throw new ConfigurationException("No username is configured for Cloudera Manager service discovery.");
            }
        }
        if (aliasService != null) {
            if (passwordAlias == null) {
                passwordAlias = "cm.discovery.password";
            }
            try {
                char[] pwd = aliasService.getPasswordFromAliasForGateway(passwordAlias);
                if (pwd != null) {
                    password = new String(pwd);
                }
            }
            catch (AliasServiceException e) {
                this.log.aliasServicePasswordError(passwordAlias, e.getLocalizedMessage());
            }
        }
        if (password == null) {
            this.log.aliasServicePasswordNotFound();
            this.isKerberos = Boolean.getBoolean("gateway.hadoop.kerberos.secured");
        }
        this.setUsername(username);
        this.setPassword(password);
        if (this.isKerberos && (subject = AuthUtils.getKerberosSubject()) != null) {
            SpnegoAuthInterceptor spnegoInterceptor = new SpnegoAuthInterceptor(subject);
            this.getHttpClient().interceptors().add(spnegoInterceptor);
        }
        this.configureTruststore(keystoreService);
    }

    public String buildUrl(String path, List<Pair> queryParams) {
        String user;
        if (this.isKerberos() && (user = this.getUsername()) != null) {
            queryParams.add(new Pair("doAs", user));
        }
        return super.buildUrl(path, queryParams);
    }

    private String getUsername() {
        String username = null;
        Authentication basicAuth = this.getAuthentication("basic");
        if (basicAuth instanceof HttpBasicAuth) {
            username = ((HttpBasicAuth)basicAuth).getUsername();
        }
        return username;
    }

    private void configureTruststore(KeystoreService keystoreService) {
        SSLContext truststoreSSLContext = TruststoreSSLContextUtils.getTruststoreSSLContext((KeystoreService)keystoreService);
        if (truststoreSSLContext != null) {
            this.getHttpClient().setSslSocketFactory(truststoreSSLContext.getSocketFactory());
        } else {
            this.log.failedToConfigureTruststore();
        }
    }
}

