/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.dispatch.DefaultDispatch;
import org.apache.knox.gateway.util.StringUtils;

public class ConfigurableDispatch
extends DefaultDispatch {
    private Set<String> requestExcludeHeaders = super.getOutboundRequestExcludeHeaders();
    private Set<String> responseExcludeHeaders = super.getOutboundResponseExcludeHeaders();
    private Set<String> responseExcludeSetCookieHeaderDirectives = super.getOutboundResponseExcludedSetCookieHeaderDirectives();
    private Boolean removeUrlEncoding = false;

    private Set<String> convertCommaDelimitedHeadersToSet(String headers) {
        return headers == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(headers.split(",")));
    }

    @Configure
    protected void setRequestExcludeHeaders(@Default(value=" ") String headers) {
        if (!" ".equals(headers)) {
            this.requestExcludeHeaders = this.convertCommaDelimitedHeadersToSet(headers);
        }
    }

    @Configure
    protected void setResponseExcludeHeaders(@Default(value=" ") String headers) {
        if (!" ".equals(headers)) {
            Set<String> headerSet = this.convertCommaDelimitedHeadersToSet(headers);
            this.populateSetCookieHeaderDirectiveExlusions(headerSet);
            this.populateHttpHeaderExlusionsOtherThanSetCookie(headerSet);
        }
    }

    private void populateSetCookieHeaderDirectiveExlusions(Set<String> headerSet) {
        String[] setCookieHeaderParts;
        Optional<String> setCookieHeader = headerSet.stream().filter(s -> StringUtils.startsWithIgnoreCase((String)s, (String)"SET-COOKIE")).findFirst();
        this.responseExcludeSetCookieHeaderDirectives = setCookieHeader.isPresent() ? ((setCookieHeaderParts = setCookieHeader.get().split(":")).length > 1 ? new HashSet<String>(Arrays.asList(setCookieHeaderParts[1].split(";"))).stream().map(e -> e.trim()).collect(Collectors.toSet()) : Collections.emptySet()) : Collections.emptySet();
    }

    private void populateHttpHeaderExlusionsOtherThanSetCookie(Set<String> headerSet) {
        Set excludedHeadersOthenThanSetCookie = headerSet.stream().filter(s -> !StringUtils.startsWithIgnoreCase((String)s, (String)"SET-COOKIE")).collect(Collectors.toSet());
        if (!excludedHeadersOthenThanSetCookie.isEmpty()) {
            this.responseExcludeHeaders = excludedHeadersOthenThanSetCookie;
        }
    }

    @Configure
    protected void setRemoveUrlEncoding(@Default(value="false") String removeUrlEncoding) {
        this.removeUrlEncoding = Boolean.parseBoolean(removeUrlEncoding);
    }

    @Override
    public Set<String> getOutboundResponseExcludeHeaders() {
        return this.responseExcludeHeaders == null ? Collections.emptySet() : this.responseExcludeHeaders;
    }

    @Override
    public Set<String> getOutboundResponseExcludedSetCookieHeaderDirectives() {
        return this.responseExcludeSetCookieHeaderDirectives == null ? Collections.emptySet() : this.responseExcludeSetCookieHeaderDirectives;
    }

    @Override
    public Set<String> getOutboundRequestExcludeHeaders() {
        return this.requestExcludeHeaders == null ? Collections.emptySet() : this.requestExcludeHeaders;
    }

    public boolean getRemoveUrlEncoding() {
        return this.removeUrlEncoding;
    }

    @Override
    public URI getDispatchUrl(HttpServletRequest request) {
        if (this.getRemoveUrlEncoding()) {
            String base = request.getRequestURI();
            StringBuffer str = new StringBuffer();
            str.append(base);
            String query = request.getQueryString();
            if (query != null) {
                try {
                    query = URLDecoder.decode(query, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                str.append('?');
                str.append(query);
            }
            this.encodeUnwiseCharacters(str);
            return URI.create(str.toString());
        }
        return super.getDispatchUrl(request);
    }
}

