/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.encrypturi.impl;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.encrypturi.EncryptStepContextParams;
import org.apache.knox.gateway.encrypturi.api.EncryptUriDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.util.urltemplate.Evaluator;
import org.apache.knox.gateway.util.urltemplate.Expander;
import org.apache.knox.gateway.util.urltemplate.Params;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class EncryptUriProcessor
implements UrlRewriteStepProcessor<EncryptUriDescriptor> {
    private String clusterName;
    private CryptoService cryptoService;
    private String template;
    private String param;

    public String getType() {
        return "encrypt";
    }

    public void initialize(UrlRewriteEnvironment environment, EncryptUriDescriptor descriptor) throws Exception {
        this.clusterName = (String)environment.getAttribute("org.apache.knox.gateway.gateway.cluster");
        GatewayServices services = (GatewayServices)environment.getAttribute("org.apache.knox.gateway.gateway.services");
        this.cryptoService = (CryptoService)services.getService(ServiceType.CRYPTO_SERVICE);
        this.template = descriptor.getTemplate();
        this.param = descriptor.getParam();
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        Template uri;
        String resolvedTemplate;
        if (!(this.param == null || this.param.isEmpty() || this.template == null || this.template.isEmpty() || (resolvedTemplate = Expander.expandToString((Template)(uri = Parser.parseTemplate((String)this.template)), (Params)context.getParameters(), (Evaluator)context.getEvaluator())) == null || resolvedTemplate.isEmpty())) {
            String endcoedUrl = this.encode(resolvedTemplate);
            EncryptStepContextParams params = new EncryptStepContextParams();
            params.addParam(this.param, Collections.singletonList(endcoedUrl));
            context.addParameters((Params)params);
            return UrlRewriteStepStatus.SUCCESS;
        }
        return UrlRewriteStepStatus.FAILURE;
    }

    public void destroy() {
    }

    private String encode(String string) throws UnsupportedEncodingException {
        EncryptionResult result = this.cryptoService.encryptForCluster(this.clusterName, "encryptQueryString", string.getBytes(StandardCharsets.UTF_8));
        string = Base64.encodeBase64URLSafeString((byte[])result.toByteAray());
        return string;
    }
}

