/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages.loggers.log4j;

import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.MessageLogger;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class Log4jMessageLogger
implements MessageLogger {
    private static String CLASS_NAME = Log4jMessageLogger.class.getName();
    private Logger logger;

    Log4jMessageLogger(Logger logger) {
        this.logger = logger;
    }

    public final boolean isLoggable(MessageLevel level) {
        return this.logger.isEnabledFor((Priority)Log4jMessageLogger.toLevel(level));
    }

    public final void log(StackTraceElement caller, MessageLevel messageLevel, String messageId, String messageText, Throwable thrown) {
        LoggingEvent event = new LoggingEvent(CLASS_NAME, (Category)this.logger, System.currentTimeMillis(), Log4jMessageLogger.toLevel(messageLevel), (Object)messageText, Thread.currentThread().getName(), Log4jMessageLogger.toThrownInformation(thrown), null, Log4jMessageLogger.toLocationInfo(caller), null);
        this.logger.callAppenders(event);
    }

    private static ThrowableInformation toThrownInformation(Throwable thrown) {
        ThrowableInformation info = null;
        if (thrown != null) {
            info = new ThrowableInformation(thrown);
        }
        return info;
    }

    private static LocationInfo toLocationInfo(StackTraceElement caller) {
        LocationInfo info = null;
        if (caller != null) {
            info = new LocationInfo(caller.getFileName(), caller.getClassName(), caller.getMethodName(), Integer.toString(caller.getLineNumber()));
        }
        return info;
    }

    private static Level toLevel(MessageLevel level) {
        switch (level) {
            case FATAL: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return Level.OFF;
    }
}

