/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceModel {
    public static final String QUALIFYING_SERVICE_PARAM_PREFIX = "discovery-";
    private static final String NULL_VALUE = "null";
    private final Type type;
    private final String service;
    private final String serviceType;
    private final String roleType;
    private final String serviceUrl;
    private final Map<String, String> qualifyingServiceParams = new ConcurrentHashMap<String, String>();
    private final Map<String, String> serviceConfigProperties = new ConcurrentHashMap<String, String>();
    private final Map<String, Map<String, String>> roleConfigProperties = new ConcurrentHashMap<String, Map<String, String>>();

    public ServiceModel(Type type, String service, String serviceType, String roleType, String serviceUrl) {
        this.type = type;
        this.service = service;
        this.serviceType = serviceType;
        this.roleType = roleType;
        this.serviceUrl = serviceUrl;
    }

    public void addQualifyingServiceParam(String name, String value) {
        String paramName = name.startsWith(QUALIFYING_SERVICE_PARAM_PREFIX) ? name : QUALIFYING_SERVICE_PARAM_PREFIX + name;
        this.qualifyingServiceParams.put(paramName, value != null ? value : NULL_VALUE);
    }

    public void addServiceProperty(String name, String value) {
        this.serviceConfigProperties.put(name, value != null ? value : NULL_VALUE);
    }

    public void addRoleProperty(String role, String name, String value) {
        this.roleConfigProperties.computeIfAbsent(role, m -> new HashMap()).put(name, value != null ? value : NULL_VALUE);
    }

    public Map<String, String> getQualifyingServiceParams() {
        return this.qualifyingServiceParams;
    }

    public String getQualifyingServiceParam(String name) {
        String paramName = name.startsWith(QUALIFYING_SERVICE_PARAM_PREFIX) ? name : QUALIFYING_SERVICE_PARAM_PREFIX + name;
        return this.qualifyingServiceParams.get(paramName);
    }

    public Map<String, String> getServiceProperties() {
        return this.serviceConfigProperties;
    }

    public Map<String, Map<String, String>> getRoleProperties() {
        return this.roleConfigProperties;
    }

    public Type getType() {
        return this.type;
    }

    public String getService() {
        return this.service;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getRoleType() {
        return this.roleType;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String toString() {
        return this.getService() + '-' + this.getServiceType() + '-' + this.getRoleType() + '-' + this.getServiceUrl();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.service, this.serviceType, this.roleType, this.serviceUrl});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceModel other = (ServiceModel)obj;
        return this.getType().equals((Object)other.getType()) && this.getService().equals(other.getService()) && this.getServiceType().equals(other.getServiceType()) && this.getRoleType().equals(other.getRoleType()) && this.getServiceUrl().equals(other.getServiceUrl());
    }

    public static enum Type {
        API,
        UI;

    }
}

