/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.util.List;

class KnoxShellTableCell<T extends Comparable<T>>
implements Comparable<KnoxShellTableCell<T>> {
    int rowIndex;
    int colIndex;
    String header;
    T value;

    KnoxShellTableCell(List<String> headers, List<List<T>> rows, int colIndex, int rowIndex) {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        if (!headers.isEmpty()) {
            this.header = headers.get(colIndex);
        }
        if (!rows.isEmpty()) {
            this.value = (Comparable)rows.get(rowIndex).get(colIndex);
        }
    }

    KnoxShellTableCell(List<String> headers, List<List<T>> rows, String name, int rowIndex) {
        this.rowIndex = rowIndex;
        if (!headers.isEmpty()) {
            this.header = name;
            this.colIndex = headers.indexOf(name);
        }
        if (!rows.isEmpty()) {
            this.value = (Comparable)rows.get(rowIndex).get(this.colIndex);
        }
    }

    KnoxShellTableCell<T> value(T value) {
        this.value = value;
        return this;
    }

    KnoxShellTableCell<T> header(String name) {
        this.header = name;
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compareTo(KnoxShellTableCell<T> other) {
        return this.value.compareTo(other.value);
    }
}

