/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.PageHeader;
import org.apache.directory.server.i18n.I18n;

final class DataPage
extends PageHeader {
    private static final short O_FIRST = 18;
    static final short O_DATA = 20;
    static final short DATA_PER_PAGE = 4076;

    DataPage(BlockIo block) {
        super(block);
    }

    static DataPage getDataPageView(BlockIo blockIo) {
        BlockView view = blockIo.getView();
        if (view != null && view instanceof DataPage) {
            return (DataPage)view;
        }
        return new DataPage(blockIo);
    }

    short getFirst() {
        return this.blockIo.readShort(18);
    }

    void setFirst(short value) {
        this.paranoiaMagicOk();
        if (value > 0 && value < 20) {
            throw new Error(I18n.err((I18n)I18n.ERR_543, (Object[])new Object[]{value}));
        }
        this.blockIo.writeShort(18, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataPage ( ");
        sb.append(super.toString()).append(", ");
        sb.append("first rowId: ").append(this.getFirst()).append(", ");
        sb.append("[p:").append(this.getPrev()).append(", ");
        sb.append("n:").append(this.getNext()).append("] )");
        return sb.toString();
    }
}

