/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.profile.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonConverter<T>
implements AttributeConverter<T> {
    private static final Logger logger = LoggerFactory.getLogger(JsonConverter.class);
    private final Class<T> clazz;
    private TypeReference<T> typeReference;

    public JsonConverter(Class<T> clazz) {
        this.clazz = clazz;
    }

    public JsonConverter(Class<T> clazz, TypeReference<T> typeReference) {
        this(clazz);
        this.typeReference = typeReference;
    }

    public T convert(Object attribute) {
        if (attribute != null) {
            if (this.clazz.isAssignableFrom(attribute.getClass())) {
                return (T)attribute;
            }
            if (attribute instanceof String || attribute instanceof JsonNode) {
                String s = attribute instanceof String ? (String)attribute : JsonHelper.toJSONString(attribute);
                try {
                    if (this.typeReference != null) {
                        return (T)JsonHelper.getMapper().readValue(s, this.typeReference);
                    }
                    return (T)JsonHelper.getMapper().readValue(s, this.clazz);
                }
                catch (IOException e) {
                    logger.error("Cannot read value", (Throwable)e);
                }
            }
        }
        return null;
    }
}

