/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultLdapContextFactory
implements LdapContextFactory {
    protected static final String SUN_CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    private static final String SIMPLE_AUTHENTICATION_MECHANISM_NAME = "simple";
    private static final Logger log = LoggerFactory.getLogger(DefaultLdapContextFactory.class);
    protected String authentication = "simple";
    protected String principalSuffix = null;
    protected String searchBase = null;
    protected String contextFactoryClassName = "com.sun.jndi.ldap.LdapCtxFactory";
    protected String url = null;
    protected String referral = "follow";
    protected String systemUsername = null;
    protected String systemPassword = null;
    private boolean usePooling = true;
    private Map<String, String> additionalEnvironment;

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public void setPrincipalSuffix(String principalSuffix) {
        this.principalSuffix = principalSuffix;
    }

    @Deprecated
    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setContextFactoryClassName(String contextFactoryClassName) {
        this.contextFactoryClassName = contextFactoryClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public void setUsePooling(boolean usePooling) {
        this.usePooling = usePooling;
    }

    public void setAdditionalEnvironment(Map<String, String> additionalEnvironment) {
        this.additionalEnvironment = additionalEnvironment;
    }

    @Override
    public LdapContext getSystemLdapContext() throws NamingException {
        return this.getLdapContext(this.systemUsername, this.systemPassword);
    }

    @Override
    @Deprecated
    public LdapContext getLdapContext(String username, String password) throws NamingException {
        if (username != null && this.principalSuffix != null) {
            username = username + this.principalSuffix;
        }
        return this.getLdapContext((Object)username, (Object)password);
    }

    @Override
    public LdapContext getLdapContext(Object principal, Object credentials) throws NamingException {
        if (this.url == null) {
            throw new IllegalStateException("An LDAP URL must be specified of the form ldap://<hostname>:<port>");
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.security.authentication", this.authentication);
        if (principal != null) {
            env.put("java.naming.security.principal", principal);
        }
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        env.put("java.naming.factory.initial", this.contextFactoryClassName);
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.referral", this.referral);
        if (this.usePooling && principal != null && principal.equals(this.systemUsername)) {
            env.put(SUN_CONNECTION_POOLING_PROPERTY, "true");
        }
        if (this.additionalEnvironment != null) {
            env.putAll(this.additionalEnvironment);
        }
        if (log.isDebugEnabled()) {
            log.debug("Initializing LDAP context using URL [" + this.url + "] and username [" + this.systemUsername + "] with pooling [" + (this.usePooling ? "enabled" : "disabled") + "]");
        }
        this.validateAuthenticationInfo(env);
        return this.createLdapContext(env);
    }

    protected LdapContext createLdapContext(Hashtable env) throws NamingException {
        return new InitialLdapContext(env, null);
    }

    private void validateAuthenticationInfo(Hashtable<String, Object> environment) throws AuthenticationException {
        Object credentials;
        if (SIMPLE_AUTHENTICATION_MECHANISM_NAME.equals(environment.get("java.naming.security.authentication")) && environment.get("java.naming.security.principal") != null && StringUtils.hasText(String.valueOf(environment.get("java.naming.security.principal"))) && ((credentials = environment.get("java.naming.security.credentials")) == null || credentials instanceof byte[] && ((byte[])credentials).length <= 0 || credentials instanceof char[] && ((char[])credentials).length <= 0 || String.class.isInstance(credentials) && !StringUtils.hasText(String.valueOf(credentials)))) {
            throw new AuthenticationException("LDAP Simple authentication requires both a principal and credentials.");
        }
    }
}

