/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.jpa.weaving.AttributeDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class MethodWeaver
extends MethodVisitor
implements Opcodes {
    protected ClassWeaver tcw;
    protected String methodName;
    protected String methodDescriptor = null;
    protected boolean methodStarted = false;

    public MethodWeaver(ClassWeaver tcw, String methodName, String methodDescriptor, MethodVisitor mv) {
        super(589824, mv);
        this.tcw = tcw;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public void visitInsn(int opcode) {
        this.weaveBeginningOfMethodIfRequired();
        if (opcode == 177) {
            this.weaveEndOfMethodIfRequired();
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitTypeInsn(opcode, desc);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.weaveBeginningOfMethodIfRequired();
        this.weaveAttributesIfRequired(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
        this.weaveBeginningOfMethodIfRequired();
        String descClassName = "";
        if (desc.length() > 3) {
            descClassName = desc.substring(3, desc.length() - 1);
        }
        if (this.tcw.classDetails.shouldWeaveInternal() && name.equals("clone") && this.tcw.classDetails.isInSuperclassHierarchy(owner) && this.tcw.classDetails.isInMetadataHierarchy(descClassName) && this.tcw.classDetails.getNameOfSuperclassImplementingCloneMethod() == null) {
            super.visitMethodInsn(opcode, owner, name, desc, intf);
            super.visitTypeInsn(192, this.tcw.classDetails.getClassName());
            super.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_post_clone", "()Ljava/lang/Object;", false);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, intf);
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.weaveBeginningOfMethodIfRequired();
        super.visitAttribute(attr);
    }

    public void weaveAttributesIfRequired(int opcode, String owner, String name, String desc) {
        AttributeDetails attributeDetails = this.tcw.classDetails.getAttributeDetailsFromClassOrSuperClass(name);
        if (attributeDetails == null || !attributeDetails.hasField() || !this.tcw.classDetails.isInMetadataHierarchy(owner)) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 180) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_get_" + name, "()" + attributeDetails.getReferenceClassType().getDescriptor(), false);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else if (opcode == 181) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveChangeTracking() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_set_" + name, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void weaveBeginningOfMethodIfRequired() {
        if (this.methodStarted) {
            return;
        }
        this.methodStarted = true;
        boolean isVirtual = false;
        AttributeDetails attributeDetails = this.tcw.classDetails.getGetterMethodToAttributeDetails().get(this.methodName);
        boolean isGetMethod = attributeDetails != null && (this.methodDescriptor.startsWith("()") || attributeDetails.isVirtualProperty() && this.methodDescriptor.startsWith("(Ljava/lang/String;)"));
        String attributeName = null;
        String referenceClassName = null;
        String setterMethodName = null;
        Type referenceClassType = null;
        String getterMethodName = null;
        int valueHoldingLocation = 1;
        int valueStorageLocation = 2;
        if (attributeDetails == null) {
            VirtualAttributeMethodInfo info = this.tcw.classDetails.getInfoForVirtualGetMethod(this.methodName);
            if (info != null && this.methodDescriptor.equals("(Ljava/lang/String;)Ljava/lang/Object;")) {
                isGetMethod = true;
                isVirtual = true;
                referenceClassName = "java.lang.Object";
                setterMethodName = info.getSetMethodName();
                referenceClassType = Type.getType("Ljava/lang/Object;");
                getterMethodName = this.methodName;
            }
        } else {
            attributeName = attributeDetails.getAttributeName();
            referenceClassName = attributeDetails.getReferenceClassName();
            setterMethodName = attributeDetails.getSetterMethodName();
            referenceClassType = attributeDetails.getReferenceClassType();
            getterMethodName = attributeDetails.getGetterMethodName();
            isVirtual = attributeDetails.isVirtualProperty();
        }
        if (isVirtual) {
            valueHoldingLocation = 2;
            valueStorageLocation = 3;
        }
        if (isVirtual || isGetMethod && !attributeDetails.hasField()) {
            if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.mv.visitVarInsn(25, 0);
                if (isVirtual) {
                    this.mv.visitVarInsn(25, 1);
                } else {
                    this.mv.visitLdcInsn(attributeName);
                }
                this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V", false);
            }
            if (!isVirtual && attributeDetails.weaveValueHolders()) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeName + "_vh", "()V", false);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeName + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.mv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "isInstantiated", "()Z", true);
                Label l0 = new Label();
                this.mv.visitJumpInsn(154, l0);
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                    this.mv.visitVarInsn(58, 4);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitInsn(1);
                    this.mv.visitFieldInsn(181, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeName + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.mv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "getValue", "()Ljava/lang/Object;", true);
                this.mv.visitTypeInsn(192, referenceClassName.replace('.', '/'));
                this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), setterMethodName, "(" + referenceClassType.getDescriptor() + ")V", false);
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 4);
                    this.mv.visitFieldInsn(181, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.mv.visitLabel(l0);
            }
        } else {
            boolean isSetMethod;
            attributeDetails = this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
            boolean bl = isSetMethod = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
            if (attributeDetails == null) {
                VirtualAttributeMethodInfo info = this.tcw.classDetails.getInfoForVirtualSetMethod(this.methodName);
                if (info != null && this.methodDescriptor.equals("(Ljava/lang/String;)Ljava/lang/Object;")) {
                    isGetMethod = true;
                    isVirtual = true;
                    referenceClassName = "java.lang.Object";
                    setterMethodName = this.methodName;
                    referenceClassType = Type.getType("Ljava/lang/Object;");
                    getterMethodName = info.getGetMethodName();
                }
            } else {
                attributeName = attributeDetails.getAttributeName();
                referenceClassName = attributeDetails.getReferenceClassName();
                setterMethodName = attributeDetails.getSetterMethodName();
                referenceClassType = attributeDetails.getReferenceClassType();
                getterMethodName = attributeDetails.getGetterMethodName();
                isVirtual = attributeDetails.isVirtualProperty();
            }
            if (isVirtual) {
                valueHoldingLocation = 2;
                valueStorageLocation = 3;
            }
            if (isVirtual || isSetMethod && !attributeDetails.hasField()) {
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    String wrapper;
                    if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                        wrapper = ClassWeaver.wrapperFor(referenceClassType.getSort());
                        this.mv.visitInsn(1);
                        if (wrapper != null) {
                            this.mv.visitVarInsn(58, valueStorageLocation + 1);
                        } else {
                            this.mv.visitVarInsn(58, valueStorageLocation);
                        }
                        this.mv.visitVarInsn(25, 0);
                        this.mv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                        Label l0 = new Label();
                        this.mv.visitJumpInsn(198, l0);
                        if (wrapper != null) {
                            this.mv.visitTypeInsn(187, wrapper);
                            this.mv.visitInsn(89);
                        }
                        this.mv.visitVarInsn(25, 0);
                        String getterArgument = "";
                        String getterReturn = referenceClassType.getDescriptor();
                        if (isVirtual) {
                            getterArgument = "Ljava/lang/String;";
                            getterReturn = "Ljava/lang/Object;";
                            this.mv.visitVarInsn(25, 1);
                        }
                        this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), getterMethodName, "(" + getterArgument + ")" + getterReturn, false);
                        if (wrapper != null) {
                            this.mv.visitMethodInsn(183, wrapper, "<init>", "(" + referenceClassType.getDescriptor() + ")V", false);
                            this.mv.visitVarInsn(58, valueStorageLocation + 1);
                        } else {
                            this.mv.visitVarInsn(58, valueStorageLocation);
                        }
                        Label l1 = new Label();
                        this.mv.visitJumpInsn(167, l1);
                        this.mv.visitLabel(l0);
                        this.mv.visitVarInsn(25, 0);
                        if (isVirtual) {
                            this.mv.visitVarInsn(25, 1);
                        } else {
                            this.mv.visitLdcInsn(attributeName);
                        }
                        this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", false);
                        this.mv.visitLabel(l1);
                        this.mv.visitVarInsn(25, 0);
                        if (isVirtual) {
                            this.mv.visitVarInsn(25, 1);
                        } else {
                            this.mv.visitLdcInsn(attributeName);
                        }
                        if (wrapper != null) {
                            this.mv.visitVarInsn(25, valueStorageLocation + 1);
                            this.mv.visitTypeInsn(187, wrapper);
                            this.mv.visitInsn(89);
                        } else {
                            this.mv.visitVarInsn(25, valueStorageLocation);
                        }
                        int opcode = referenceClassType.getOpcode(21);
                        this.mv.visitVarInsn(opcode, valueHoldingLocation);
                        if (wrapper != null) {
                            this.mv.visitMethodInsn(183, wrapper, "<init>", "(" + referenceClassType.getDescriptor() + ")V", false);
                        }
                        this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
                    } else {
                        wrapper = ClassWeaver.wrapperFor(referenceClassType.getSort());
                        if (wrapper != null) {
                            this.mv.visitTypeInsn(187, wrapper);
                            this.mv.visitInsn(89);
                        }
                        this.mv.visitVarInsn(25, 0);
                        String getterArgument = "";
                        String getterReturn = referenceClassType.getDescriptor();
                        if (isVirtual) {
                            getterArgument = "Ljava/lang/String;";
                            getterReturn = "Ljava/lang/Object;";
                            this.mv.visitVarInsn(25, 1);
                        }
                        this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), getterMethodName, "(" + getterArgument + ")" + getterReturn, false);
                        if (wrapper != null) {
                            this.mv.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
                            this.mv.visitVarInsn(58, valueStorageLocation + 1);
                        } else {
                            this.mv.visitVarInsn(58, valueStorageLocation);
                        }
                        this.mv.visitVarInsn(25, 0);
                        if (isVirtual) {
                            this.mv.visitVarInsn(25, 1);
                        } else {
                            this.mv.visitLdcInsn(attributeName);
                        }
                        if (wrapper != null) {
                            this.mv.visitVarInsn(25, valueStorageLocation + 1);
                            this.mv.visitTypeInsn(187, wrapper);
                            this.mv.visitInsn(89);
                        } else {
                            this.mv.visitVarInsn(25, valueStorageLocation);
                        }
                        int opcode = referenceClassType.getOpcode(21);
                        this.mv.visitVarInsn(opcode, valueHoldingLocation);
                        if (wrapper != null) {
                            this.mv.visitMethodInsn(183, wrapper, "<init>", "(" + referenceClassType.getDescriptor() + ")V", false);
                        }
                        this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
                    }
                } else if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                    this.mv.visitVarInsn(25, 0);
                    if (isVirtual) {
                        this.mv.visitVarInsn(25, 1);
                    } else {
                        this.mv.visitLdcInsn(attributeName);
                    }
                    this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", false);
                }
            }
        }
    }

    public void weaveEndOfMethodIfRequired() {
        boolean isSetMethod;
        AttributeDetails attributeDetails = this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
        boolean bl = isSetMethod = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
        if (isSetMethod && !attributeDetails.hasField() && attributeDetails.weaveValueHolders()) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V", false);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
            this.mv.visitVarInsn(25, 1);
            this.mv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setValue", "(Ljava/lang/Object;)V", true);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
            this.mv.visitInsn(4);
            this.mv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setIsCoordinatedWithProperty", "(Z)V", true);
        }
    }
}

