/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.descriptor.impl.FilterParamDescriptorImpl;

public class FilterDescriptorImpl
implements FilterDescriptor {
    private ResourceDescriptor parent;
    private List<FilterParamDescriptor> params;
    private String name;
    private String role;
    private String impl;

    FilterDescriptorImpl(ResourceDescriptor parent) {
        this.parent = parent;
        this.params = new ArrayList<FilterParamDescriptor>();
    }

    public ResourceDescriptor up() {
        return this.parent;
    }

    public FilterDescriptor name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public FilterDescriptor role(String role) {
        this.role = role;
        return this;
    }

    public String role() {
        return this.role;
    }

    public FilterDescriptor impl(String impl) {
        this.impl = impl;
        return this;
    }

    public FilterDescriptor impl(Class<? extends Filter> type) {
        this.impl = type.getName();
        return this;
    }

    public String impl() {
        return this.impl;
    }

    public List<FilterParamDescriptor> params() {
        return this.params;
    }

    public FilterParamDescriptor param() {
        FilterParamDescriptor param = this.createParam();
        this.param(param);
        return param;
    }

    public FilterParamDescriptor createParam() {
        return new FilterParamDescriptorImpl(this);
    }

    public FilterDescriptor param(FilterParamDescriptor param) {
        param.up((FilterDescriptor)this);
        this.params.add(param);
        return this;
    }

    public FilterDescriptor params(List<FilterParamDescriptor> params) {
        if (params != null) {
            for (FilterParamDescriptor param : params) {
                param.up((FilterDescriptor)this);
            }
            this.params.addAll(params);
        }
        return this;
    }
}

