/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.websockets;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.apache.knox.gateway.websockets.MessageEventCallback;

@ClientEndpoint
public class ProxyInboundSocket {
    final MessageEventCallback callback;

    public ProxyInboundSocket(MessageEventCallback callback) {
        this.callback = callback;
    }

    @OnOpen
    public void onClientOpen(Session backendSession) {
        this.callback.onConnectionOpen(backendSession);
    }

    @OnClose
    public void onClientClose(CloseReason reason) {
        this.callback.onConnectionClose(reason);
    }

    @OnError
    public void onClientError(Throwable cause) {
        this.callback.onError(cause);
    }

    @OnMessage(maxMessageSize=0x7FFFFFFFL)
    public void onBackendMessage(String message, Session session) {
        this.callback.onMessageText(message, session);
    }

    @OnMessage(maxMessageSize=0x7FFFFFFFL)
    public void onBackendMessageBinary(byte[] message, boolean last, Session session) {
        this.callback.onMessageBinary(message, last, session);
    }
}

