/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.hostmap.HostMapper;
import org.apache.knox.gateway.services.hostmap.HostMapperService;
import org.apache.knox.gateway.svcregfunc.api.ServiceMappedUrlFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;

public class ServiceMappedUrlFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServiceMappedUrlFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServiceMappedUrlFunctionDescriptor> {
    private HostMapper hostmap;

    public String name() {
        return "serviceMappedUrl";
    }

    @Override
    public void initialize(UrlRewriteEnvironment environment, ServiceMappedUrlFunctionDescriptor descriptor) throws Exception {
        super.initialize(environment, descriptor);
        HostMapperService hostmapService = (HostMapperService)this.services().getService(ServiceType.HOST_MAPPING_SERVICE);
        if (hostmapService != null) {
            this.hostmap = hostmapService.getHostMapper(this.cluster());
        }
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            UrlRewriter.Direction direction = context.getDirection();
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                parameter = this.resolve(direction, parameter);
                results.add(parameter);
            }
        }
        return results;
    }

    public String resolve(UrlRewriter.Direction direction, String parameter) throws Exception {
        String url = this.lookupServiceUrl(parameter);
        if (url != null) {
            URI inputUri = new URI(url);
            String host = inputUri.getHost();
            if (host != null && this.hostmap != null) {
                switch (direction) {
                    case IN: {
                        host = this.hostmap.resolveInboundHostName(host);
                        break;
                    }
                    case OUT: {
                        host = this.hostmap.resolveOutboundHostName(host);
                    }
                }
            }
            URI outputUri = new URI(inputUri.getScheme(), inputUri.getUserInfo(), host, inputUri.getPort(), inputUri.getPath(), inputUri.getQuery(), inputUri.getFragment());
            parameter = outputUri.toString();
        }
        return parameter;
    }
}

