/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.hiorgserver;

import org.pac4j.oauth.profile.OAuth20Profile;

public class HiOrgServerProfile
extends OAuth20Profile {
    private static final long serialVersionUID = 1889864079390590548L;

    public String getUsername() {
        return (String)this.getAttribute("username", String.class);
    }

    public String getFirstName() {
        return (String)this.getAttribute("vorname", String.class);
    }

    public String getFamilyName() {
        return (String)this.getAttribute("name", String.class);
    }

    public String getDisplayName() {
        return (String)this.getAttribute("fullname", String.class);
    }

    public int getRolesAsInteger() {
        Integer rolesAsInt = (Integer)this.getAttribute("gruppe", Integer.class);
        if (rolesAsInt != null) {
            return rolesAsInt;
        }
        return 0;
    }

    public boolean hasRole(int roleId) {
        return (this.getRolesAsInteger() & roleId) == roleId;
    }

    public String getOrganisationId() {
        return (String)this.getAttribute("orga", String.class);
    }

    public String getOrganisationName() {
        return (String)this.getAttribute("organisation", String.class);
    }

    public String getPosition() {
        return (String)this.getAttribute("funktion", String.class);
    }

    public boolean isLeader() {
        return (Boolean)this.getAttribute("leitung", Boolean.class);
    }

    public String getAlternativeId() {
        String alternativeId = this.getUsername() + "@" + this.getOrganisationId();
        return alternativeId.toLowerCase();
    }

    public String getTypedAlternativeId() {
        return ((Object)((Object)this)).getClass().getName() + "#" + this.getAlternativeId();
    }
}

