/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cli;

import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.cli.AbstractCli;
import org.ldaptive.props.BindConnectionInitializerPropertySource;
import org.ldaptive.props.ConnectionConfigPropertySource;
import org.ldaptive.props.SslConfigPropertySource;
import org.ldaptive.ssl.SslConfig;

public class DeleteOperationCli
extends AbstractCli {
    private static final String OPT_DN = "dn";
    private static final String COMMAND_NAME = "ldapdelete";

    public static void main(String[] args) {
        DeleteOperationCli cli = new DeleteOperationCli();
        int status = cli.performAction(args);
        System.exit(status);
    }

    @Override
    protected void initOptions() {
        this.options.addOption(new Option(OPT_DN, true, "entry DN"));
        Map<String, String> desc = this.getArgDesc(ConnectionConfig.class, SslConfig.class);
        for (String s : ConnectionConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : SslConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : BindConnectionInitializerPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        super.initOptions();
    }

    @Override
    protected int dispatch(CommandLine line) throws Exception {
        if (!line.hasOption("help")) {
            return this.delete(this.initConnectionFactory(line), line.getOptionValues(OPT_DN));
        }
        this.printHelp();
        return -1;
    }

    protected int delete(ConnectionFactory cf, String[] entryDns) throws Exception {
        Connection conn = cf.getConnection();
        conn.open();
        for (String dn : entryDns) {
            DeleteOperation op = new DeleteOperation(conn);
            op.execute(new DeleteRequest(dn));
            System.out.println(String.format("Deleted entry: %s", dn));
        }
        conn.close();
        return 0;
    }

    @Override
    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

