/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BulkLoader;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.ValueArrayCursor;
import org.apache.directory.mavibot.btree.ValueBTreeCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

abstract class AbstractValueHolder<V>
implements ValueHolder<V> {
    protected BTree<V, V> valueBtree;
    protected V[] valueArray;
    protected ElementSerializer<V> valueSerializer;
    protected int valueThresholdUp = 1;
    protected int valueThresholdLow = 1;
    protected int nbArrayElems;

    AbstractValueHolder() {
    }

    @Override
    public boolean isSubBtree() {
        return this.valueBtree != null;
    }

    @Override
    public ValueHolder<V> clone() throws CloneNotSupportedException {
        ValueHolder copy = (ValueHolder)super.clone();
        return copy;
    }

    @Override
    public ValueCursor<V> getCursor() {
        if (this.valueBtree != null) {
            return new ValueBTreeCursor<V>(this.valueBtree);
        }
        return new ValueArrayCursor<V>(this.valueArray);
    }

    private int findPos(V value) {
        int result;
        if (this.valueArray.length == 0) {
            return -1;
        }
        int pivot = this.valueArray.length / 2;
        int low = 0;
        int high = this.valueArray.length - 1;
        Comparator<V> comparator = this.valueSerializer.getComparator();
        while (high > low) {
            switch (high - low) {
                case 1: {
                    result = comparator.compare(value, this.valueArray[pivot]);
                    if (result == 0) {
                        return pivot;
                    }
                    if (result < 0) {
                        if (pivot == low) {
                            return -(low + 1);
                        }
                        result = comparator.compare(value, this.valueArray[low]);
                        if (result == 0) {
                            return low;
                        }
                        if (result < 0) {
                            return -(low + 1);
                        }
                        return -(low + 2);
                    }
                    if (pivot == high) {
                        return -(high + 2);
                    }
                    result = comparator.compare(value, this.valueArray[high]);
                    if (result == 0) {
                        return high;
                    }
                    if (result < 0) {
                        return -(high + 1);
                    }
                    return -(high + 2);
                }
            }
            result = comparator.compare(value, this.valueArray[pivot]);
            if (result == 0) {
                return pivot;
            }
            if (result < 0) {
                high = pivot - 1;
            } else {
                low = pivot + 1;
            }
            pivot = (high + low) / 2;
        }
        result = comparator.compare(value, this.valueArray[pivot]);
        if (result == 0) {
            return pivot;
        }
        if (result < 0) {
            return -(pivot + 1);
        }
        return -(pivot + 2);
    }

    private boolean arrayContains(V value) {
        if (this.valueArray.length == 0) {
            return false;
        }
        return this.findPos(value) >= 0;
    }

    protected boolean btreeContains(V value) {
        try {
            return this.valueBtree.hasKey(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (KeyNotFoundException knfe) {
            knfe.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean contains(V checkedValue) {
        if (this.valueArray == null) {
            return this.btreeContains(checkedValue);
        }
        return this.arrayContains(checkedValue);
    }

    protected abstract void createSubTree();

    protected abstract void manageSubTree();

    private void addInArray(final V value) {
        if (this.size() >= this.valueThresholdUp) {
            this.createSubTree();
            Iterator valueIterator = new Iterator<Tuple<V, V>>(){
                int pos = 0;

                @Override
                public Tuple<V, V> next() {
                    if (this.pos == AbstractValueHolder.this.valueArray.length) {
                        ++this.pos;
                        return new Tuple<Object, Object>(value, value);
                    }
                    Object oldValue = AbstractValueHolder.this.valueArray[this.pos];
                    ++this.pos;
                    return new Tuple(oldValue, oldValue);
                }

                @Override
                public boolean hasNext() {
                    return this.pos < AbstractValueHolder.this.valueArray.length + 1;
                }

                @Override
                public void remove() {
                }
            };
            try {
                BulkLoader.load(this.valueBtree, valueIterator, this.valueArray.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.manageSubTree();
            this.valueArray = null;
        } else if (this.valueArray == null) {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), 1);
            this.nbArrayElems = 1;
            this.valueArray[0] = value;
        } else {
            int pos = this.findPos(value);
            if (pos >= 0) {
                return;
            }
            pos = -(pos + 1);
            Object[] newValueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), this.valueArray.length + 1);
            System.arraycopy(this.valueArray, 0, newValueArray, 0, pos);
            newValueArray[pos] = value;
            System.arraycopy(this.valueArray, pos, newValueArray, pos + 1, this.valueArray.length - pos);
            this.valueArray = newValueArray;
        }
    }

    private void addInBtree(V value) {
        try {
            this.valueBtree.insert(value, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void add(V value) {
        if (this.valueBtree == null) {
            this.addInArray(value);
        } else {
            this.addInBtree(value);
        }
    }

    @Override
    public V replaceValueArray(V newValue) {
        if (this.isSubBtree()) {
            throw new IllegalStateException("method is not applicable for the duplicate B-Trees");
        }
        V tmp = this.valueArray[0];
        this.nbArrayElems = 1;
        this.valueArray[0] = newValue;
        return tmp;
    }
}

