/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.ext;

import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.ext.UrlRewriteMatchDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Template;

public class UrlRewriteMatchProcessorExt
implements UrlRewriteStepProcessor<UrlRewriteMatchDescriptor> {
    private Matcher<Void> matcher;

    @Override
    public String getType() {
        return "match";
    }

    @Override
    public void initialize(UrlRewriteEnvironment environment, UrlRewriteMatchDescriptor descriptor) throws Exception {
        Template template = descriptor.template();
        this.matcher = template == null ? null : new Matcher(descriptor.template(), null);
    }

    @Override
    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        UrlRewriteStepStatus status = UrlRewriteStepStatus.SUCCESS;
        if (this.matcher != null) {
            status = UrlRewriteStepStatus.FAILURE;
            Matcher.Match match = this.matcher.match(context.getCurrentUrl());
            if (match != null) {
                context.addParameters(match.getParams());
                status = UrlRewriteStepStatus.SUCCESS;
            }
        }
        return status;
    }

    @Override
    public void destroy() {
        this.matcher = null;
    }
}

