/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.util.X509CertificateUtil;

public class DefaultKeystoreService
implements KeystoreService {
    private static final String DN_TEMPLATE = "CN={0},OU=Test,O=Hadoop,L=Test,ST=Test,C=US";
    public static final String CREDENTIALS_SUFFIX = "-credentials.";
    private static final String CERT_GEN_MODE = "hadoop.gateway.cert.gen.mode";
    private static final String CERT_GEN_MODE_LOCALHOST = "localhost";
    private static final String CERT_GEN_MODE_HOSTNAME = "hostname";
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static GatewayResources RES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    Cache<CacheKey, String> cache;
    private GatewayConfig config;
    private MasterService masterService;
    private Path keyStoreDirPath;
    private String credentialStoreAlgorithm;
    private String credentialStoreType;
    private String credentialsSuffix;
    private String selfSigningCertificateAlgorithm;

    public void setMasterService(MasterService ms) {
        this.masterService = ms;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        this.keyStoreDirPath = Paths.get(config.getGatewayKeystoreDir(), new String[0]);
        if (Files.notExists(this.keyStoreDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.keyStoreDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ServiceLifecycleException(RES.failedToCreateKeyStoreDirectory(this.keyStoreDirPath.toString()));
            }
        }
        if (this.cache == null) {
            this.cache = Caffeine.newBuilder().expireAfterAccess(config.getKeystoreCacheEntryTimeToLiveInMinutes(), TimeUnit.MINUTES).maximumSize(config.getKeystoreCacheSizeLimit()).build();
        }
        this.credentialStoreAlgorithm = config.getCredentialStoreAlgorithm();
        this.credentialStoreType = config.getCredentialStoreType();
        this.credentialsSuffix = CREDENTIALS_SUFFIX + this.credentialStoreType.toLowerCase(Locale.ROOT);
        this.selfSigningCertificateAlgorithm = config.getSelfSigningCertificateAlgorithm();
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public void createKeystoreForGateway() throws KeystoreServiceException {
        this.createKeyStore(Paths.get(this.config.getIdentityKeystorePath(), new String[0]), this.config.getIdentityKeystoreType(), this.getKeyStorePassword(this.config.getIdentityKeystorePasswordAlias()));
    }

    public KeyStore getKeystoreForGateway() throws KeystoreServiceException {
        return this.getKeystore(Paths.get(this.config.getIdentityKeystorePath(), new String[0]), this.config.getIdentityKeystoreType(), this.config.getIdentityKeystorePasswordAlias(), true);
    }

    public KeyStore getTruststoreForHttpClient() throws KeystoreServiceException {
        String trustStorePath = this.config.getHttpClientTruststorePath();
        if (trustStorePath == null) {
            return null;
        }
        return this.getKeystore(Paths.get(trustStorePath, new String[0]), this.config.getHttpClientTruststoreType(), this.config.getHttpClientTruststorePasswordAlias(), true);
    }

    public KeyStore getSigningKeystore() throws KeystoreServiceException {
        return this.getSigningKeystore(null);
    }

    public KeyStore getSigningKeystore(String keystoreName) throws KeystoreServiceException {
        String passwordAlias;
        String keyStoreType;
        Path keyStoreFile;
        if (keystoreName != null) {
            keyStoreFile = this.keyStoreDirPath.resolve(keystoreName + ".jks");
            keyStoreType = "jks";
            passwordAlias = null;
        } else {
            keyStoreFile = Paths.get(this.config.getSigningKeystorePath(), new String[0]);
            keyStoreType = this.config.getSigningKeystoreType();
            passwordAlias = this.config.getSigningKeystorePasswordAlias();
        }
        return this.getKeystore(keyStoreFile, keyStoreType, passwordAlias, true);
    }

    public void addSelfSignedCertForGateway(String alias, char[] passphrase) throws KeystoreServiceException {
        this.addSelfSignedCertForGateway(alias, passphrase, null);
    }

    public void addSelfSignedCertForGateway(String alias, char[] passphrase, String hostname) throws KeystoreServiceException {
        this.addCertForGateway(alias, passphrase, hostname);
    }

    private synchronized void addCertForGateway(String alias, char[] passphrase, String hostname) throws KeystoreServiceException {
        try {
            X509Certificate cert;
            String dn;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair KPair = keyPairGenerator.generateKeyPair();
            if (hostname == null) {
                hostname = System.getProperty(CERT_GEN_MODE, CERT_GEN_MODE_LOCALHOST);
            }
            if (hostname.equals(CERT_GEN_MODE_HOSTNAME)) {
                dn = this.buildDistinguishedName(InetAddress.getLocalHost().getHostName());
                cert = X509CertificateUtil.generateCertificate((String)dn, (KeyPair)KPair, (int)365, (String)this.selfSigningCertificateAlgorithm);
            } else {
                dn = this.buildDistinguishedName(hostname);
                cert = X509CertificateUtil.generateCertificate((String)dn, (KeyPair)KPair, (int)365, (String)this.selfSigningCertificateAlgorithm);
            }
            KeyStore privateKS = this.getKeystoreForGateway();
            privateKS.setKeyEntry(alias, KPair.getPrivate(), passphrase, new Certificate[]{cert});
            this.writeKeyStoreToFile(privateKS, Paths.get(this.config.getIdentityKeystorePath(), new String[0]), this.getKeyStorePassword(this.config.getIdentityKeystorePasswordAlias()));
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.failedToAddSeflSignedCertForGateway(alias, e);
            throw new KeystoreServiceException(e);
        }
    }

    private String buildDistinguishedName(String hostname) {
        MessageFormat headerFormatter = new MessageFormat(DN_TEMPLATE, Locale.ROOT);
        String[] paramArray = new String[]{hostname};
        return headerFormatter.format(paramArray);
    }

    public void createCredentialStoreForCluster(String clusterName) throws KeystoreServiceException {
        this.checkExistingCredentialStore(clusterName);
        this.createKeyStore(this.keyStoreDirPath.resolve(clusterName + this.credentialsSuffix), this.credentialStoreType, this.masterService.getMasterSecret());
    }

    private void checkExistingCredentialStore(String clusterName) {
        File[] existingClusterCredentialStoreFiles = this.keyStoreDirPath.toFile().listFiles((FileFilter)new PrefixFileFilter(clusterName + CREDENTIALS_SUFFIX));
        if (existingClusterCredentialStoreFiles != null) {
            for (File existingClusterCredentialStoreFile : existingClusterCredentialStoreFiles) {
                String existingCredentialStoreType = FilenameUtils.getExtension((String)existingClusterCredentialStoreFile.getName());
                if (this.credentialStoreType.equals(existingCredentialStoreType)) continue;
                LOG.credentialStoreForClusterFoundWithDifferentType(clusterName, existingCredentialStoreType);
            }
        }
    }

    public boolean isCredentialStoreForClusterAvailable(String clusterName) throws KeystoreServiceException {
        Path keyStoreFilePath = this.keyStoreDirPath.resolve(clusterName + this.credentialsSuffix);
        try {
            return this.isKeyStoreAvailable(keyStoreFilePath, this.credentialStoreType, this.masterService.getMasterSecret());
        }
        catch (IOException | KeyStoreException e) {
            throw new KeystoreServiceException(e);
        }
    }

    public boolean isKeystoreForGatewayAvailable() throws KeystoreServiceException {
        Path keyStoreFilePath = Paths.get(this.config.getIdentityKeystorePath(), new String[0]);
        try {
            return this.isKeyStoreAvailable(keyStoreFilePath, this.config.getIdentityKeystoreType(), this.getKeyStorePassword(this.config.getIdentityKeystorePasswordAlias()));
        }
        catch (IOException | KeyStoreException e) {
            throw new KeystoreServiceException(e);
        }
    }

    public Key getKeyForGateway(char[] passphrase) throws KeystoreServiceException {
        return this.getKeyForGateway(this.config.getIdentityKeyAlias(), passphrase);
    }

    public Key getKeyForGateway(String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getKeyFromKeystore(this.getKeystoreForGateway(), alias, passphrase);
    }

    public Certificate getCertificateForGateway() throws KeystoreServiceException, KeyStoreException {
        KeyStore ks = this.getKeystoreForGateway();
        return ks == null ? null : ks.getCertificate(this.config.getIdentityKeyAlias());
    }

    public Key getSigningKey(String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getSigningKey(null, alias, passphrase);
    }

    public Key getSigningKey(String keystoreName, String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getKeyFromKeystore(this.getSigningKeystore(keystoreName), alias, passphrase);
    }

    private Key getKeyFromKeystore(KeyStore ks, String alias, char[] passphrase) {
        Key key = null;
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
            LOG.assumingKeyPassphraseIsMaster();
        }
        if (ks != null) {
            try {
                key = ks.getKey(alias, passphrase);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                LOG.failedToGetKeyForGateway(alias, e);
            }
        }
        return key;
    }

    public KeyStore getCredentialStoreForCluster(String clusterName) throws KeystoreServiceException {
        return this.getKeystore(this.keyStoreDirPath.resolve(clusterName + this.credentialsSuffix), this.credentialStoreType, null, false);
    }

    public void addCredentialForCluster(String clusterName, String alias, String value) throws KeystoreServiceException {
        this.addCredentialsForCluster(clusterName, Collections.singletonMap(alias, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCredentialsForCluster(String clusterName, Map<String, String> credentials) throws KeystoreServiceException {
        DefaultKeystoreService defaultKeystoreService = this;
        synchronized (defaultKeystoreService) {
            this.removeFromCache(clusterName, credentials.keySet());
            KeyStore ks = this.getCredentialStoreForCluster(clusterName);
            if (ks != null) {
                try {
                    for (Map.Entry<String, String> credential : credentials.entrySet()) {
                        SecretKeySpec key = new SecretKeySpec(credential.getValue().getBytes(StandardCharsets.UTF_8), this.credentialStoreAlgorithm);
                        ks.setKeyEntry(credential.getKey(), key, this.masterService.getMasterSecret(), null);
                    }
                    Path keyStoreFilePath = this.keyStoreDirPath.resolve(clusterName + this.credentialsSuffix);
                    this.writeKeyStoreToFile(ks, keyStoreFilePath, this.masterService.getMasterSecret());
                    this.addToCache(clusterName, credentials);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOG.failedToAddCredentialForCluster(clusterName, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getCredentialForCluster(String clusterName, String alias) throws KeystoreServiceException {
        char[] credential;
        DefaultKeystoreService defaultKeystoreService = this;
        synchronized (defaultKeystoreService) {
            KeyStore ks;
            credential = this.checkCache(clusterName, alias);
            if (credential == null && (ks = this.getCredentialStoreForCluster(clusterName)) != null) {
                try {
                    credential = this.getCredentialForCluster(clusterName, alias, ks);
                }
                catch (KeystoreServiceException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, (Exception)((Object)e));
                }
            }
        }
        return credential;
    }

    public char[] getCredentialForCluster(String clusterName, String alias, KeyStore ks) throws KeystoreServiceException {
        try {
            char[] credential = null;
            Key credentialKey = ks.getKey(alias, this.masterService.getMasterSecret());
            if (credentialKey == null) {
                credentialKey = ks.getKey(alias.toLowerCase(Locale.ROOT), this.masterService.getMasterSecret());
            }
            if (credentialKey != null) {
                String credentialString = new String(credentialKey.getEncoded(), StandardCharsets.UTF_8);
                credential = credentialString.toCharArray();
                this.addToCache(clusterName, alias, credentialString);
            }
            return credential;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeystoreServiceException((Exception)e);
        }
    }

    public void removeCredentialForCluster(String clusterName, String alias) throws KeystoreServiceException {
        this.removeCredentialsForCluster(clusterName, Collections.singleton(alias));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCredentialsForCluster(String clusterName, Set<String> aliases) throws KeystoreServiceException {
        DefaultKeystoreService defaultKeystoreService = this;
        synchronized (defaultKeystoreService) {
            KeyStore ks = this.getCredentialStoreForCluster(clusterName);
            if (ks != null) {
                try {
                    for (String alias : aliases) {
                        if (!ks.containsAlias(alias)) continue;
                        ks.deleteEntry(alias);
                    }
                    this.removeFromCache(clusterName, aliases);
                    Path keyStoreFilePath = this.keyStoreDirPath.resolve(clusterName + this.credentialsSuffix);
                    this.writeKeyStoreToFile(ks, keyStoreFilePath, this.masterService.getMasterSecret());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOG.failedToRemoveCredentialForCluster(clusterName, e);
                }
            }
        }
    }

    private char[] checkCache(String clusterName, String alias) {
        String cachedCredential = (String)this.cache.getIfPresent((Object)CacheKey.of(clusterName, alias));
        return cachedCredential == null ? null : cachedCredential.toCharArray();
    }

    private void addToCache(String clusterName, String alias, String credentialString) {
        this.cache.put((Object)CacheKey.of(clusterName, alias), (Object)credentialString);
    }

    private void addToCache(String clusterName, Map<String, String> credentials) {
        for (String alias : credentials.keySet()) {
            this.cache.put((Object)CacheKey.of(clusterName, alias), (Object)credentials.get(alias));
        }
    }

    private void removeFromCache(String clusterName, Set<String> aliases) {
        HashSet<CacheKey> keys = new HashSet<CacheKey>();
        for (String alias : aliases) {
            keys.add(CacheKey.of(clusterName, alias));
        }
        this.cache.invalidateAll(keys);
    }

    public String getKeystorePath() {
        return this.config.getIdentityKeystorePath();
    }

    private synchronized KeyStore getKeystore(Path keystorePath, String keystoreType, String alias, boolean failIfNotAccessible) throws KeystoreServiceException {
        if (failIfNotAccessible) {
            if (Files.notExists(keystorePath, new LinkOption[0])) {
                LOG.keystoreFileDoesNotExist(keystorePath.toString());
                throw new KeystoreServiceException("The keystore file does not exist: " + keystorePath.toString());
            }
            if (!Files.isRegularFile(keystorePath, new LinkOption[0])) {
                LOG.keystoreFileIsNotAFile(keystorePath.toString());
                throw new KeystoreServiceException("The keystore file is not a file: " + keystorePath.toString());
            }
            if (!Files.isReadable(keystorePath)) {
                LOG.keystoreFileIsNotAccessible(keystorePath.toString());
                throw new KeystoreServiceException("The keystore file cannot be read: " + keystorePath.toString());
            }
        }
        return this.loadKeyStore(keystorePath, keystoreType, this.getKeyStorePassword(alias));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean isKeyStoreAvailable(Path keyStoreFilePath, String storeType, char[] password) throws KeyStoreException, IOException {
        if (!Files.exists(keyStoreFilePath, new LinkOption[0])) return false;
        if (!Files.isRegularFile(keyStoreFilePath, new LinkOption[0])) return false;
        if (!Files.isReadable(keyStoreFilePath)) return false;
        try (InputStream input = Files.newInputStream(keyStoreFilePath, new OpenOption[0]);){
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(input, password);
            boolean bl = true;
            return bl;
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToLoadKeystore(keyStoreFilePath.toString(), storeType, e);
            return false;
        }
        catch (IOException | KeyStoreException e) {
            LOG.failedToLoadKeystore(keyStoreFilePath.toString(), storeType, e);
            throw e;
        }
    }

    synchronized KeyStore createKeyStore(Path keystoreFilePath, String keystoreType, char[] password) throws KeystoreServiceException {
        Path parentPath = keystoreFilePath.getParent();
        if (parentPath != null && !Files.isDirectory(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.failedToCreateKeystore(keystoreFilePath.toString(), keystoreType, e);
                throw new KeystoreServiceException((Exception)e);
            }
        }
        try {
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(null, null);
            this.writeKeyStoreToFile(ks, keystoreFilePath, password);
            return ks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToCreateKeystore(keystoreFilePath.toString(), keystoreType, e);
            throw new KeystoreServiceException(e);
        }
    }

    synchronized KeyStore loadKeyStore(Path keyStoreFilePath, String storeType, char[] password) throws KeystoreServiceException {
        try {
            KeyStore keyStore;
            block27: {
                keyStore = KeyStore.getInstance(storeType);
                if (Files.exists(keyStoreFilePath, new LinkOption[0])) {
                    try (FileChannel fileChannel = FileChannel.open(keyStoreFilePath, StandardOpenOption.READ);){
                        fileChannel.lock(0L, Long.MAX_VALUE, true);
                        try (InputStream input = Channels.newInputStream(fileChannel);){
                            keyStore.load(input, password);
                            break block27;
                        }
                    }
                }
                keyStore.load(null, password);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToLoadKeystore(keyStoreFilePath.toString(), storeType, e);
            throw new KeystoreServiceException(e);
        }
    }

    public synchronized KeyStore loadKeyStore(String path, String keystoreType, String password) throws KeystoreServiceException {
        try {
            return this.createKeyStore(FileSystems.getDefault().getPath(path, new String[0]), keystoreType, password.toCharArray());
        }
        catch (Exception e) {
            throw new KeystoreServiceException(e);
        }
    }

    public synchronized KeyStore loadTruststore(String path, String keystoreType, String password) throws KeystoreServiceException {
        try {
            return this.loadKeyStore(FileSystems.getDefault().getPath(path, new String[0]), keystoreType, password.toCharArray());
        }
        catch (Exception e) {
            throw new KeystoreServiceException(e);
        }
    }

    synchronized void writeKeyStoreToFile(KeyStore keyStore, Path path, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileChannel.lock();
            try (OutputStream out = Channels.newOutputStream(fileChannel);){
                keyStore.store(out, password);
            }
        }
    }

    private char[] getKeyStorePassword(String alias) throws KeystoreServiceException {
        char[] password = null;
        if (alias != null && !alias.isEmpty()) {
            password = this.getCredentialForCluster("__gateway", alias);
        }
        return password == null ? this.masterService.getMasterSecret() : password;
    }

    private static class CacheKey {
        private final String clusterName;
        private final String alias;

        private CacheKey(String clusterName, String alias) {
            this.clusterName = clusterName;
            this.alias = alias;
        }

        private static CacheKey of(String clusterName, String alias) {
            return new CacheKey(clusterName, alias);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }
}

