/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.SSLService;
import org.apache.knox.gateway.util.X500PrincipalParser;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettySSLService
implements SSLService {
    private static final String EPHEMERAL_DH_KEY_SIZE_PROPERTY = "jdk.tls.ephemeralDHKeySize";
    private static final String GATEWAY_CREDENTIAL_STORE_NAME = "__gateway";
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private KeystoreService keystoreService;
    private AliasService aliasService;

    public void setAliasService(AliasService as) {
        this.aliasService = as;
    }

    public void setKeystoreService(KeystoreService ks) {
        this.keystoreService = ks;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        System.setProperty(EPHEMERAL_DH_KEY_SIZE_PROPERTY, config.getEphemeralDHKeySize());
        try {
            if (!this.keystoreService.isCredentialStoreForClusterAvailable(GATEWAY_CREDENTIAL_STORE_NAME)) {
                log.creatingCredentialStoreForGateway();
                this.keystoreService.createCredentialStoreForCluster(GATEWAY_CREDENTIAL_STORE_NAME);
            } else {
                log.credentialStoreForGatewayFoundNotCreating();
            }
        }
        catch (KeystoreServiceException e) {
            throw new ServiceLifecycleException("Keystore was not loaded properly - the provided password may not match the password for the keystore.", (Exception)((Object)e));
        }
        try {
            if (!this.keystoreService.isKeystoreForGatewayAvailable()) {
                char[] passphrase;
                log.creatingKeyStoreForGateway();
                this.keystoreService.createKeystoreForGateway();
                try {
                    passphrase = this.aliasService.getGatewayIdentityPassphrase();
                }
                catch (AliasServiceException e) {
                    throw new ServiceLifecycleException("Error accessing credential store for the gateway.", (Exception)((Object)e));
                }
                this.keystoreService.addSelfSignedCertForGateway(config.getIdentityKeyAlias(), passphrase);
            } else {
                log.keyStoreForGatewayFoundNotCreating();
            }
            this.logAndValidateCertificate(config);
        }
        catch (KeystoreServiceException e) {
            throw new ServiceLifecycleException("The identity keystore was not loaded properly - the provided password may not match the password for the keystore.", (Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logAndValidateCertificate(GatewayConfig config) throws ServiceLifecycleException {
        Certificate cert;
        String identityKeyAlias = config.getIdentityKeyAlias();
        try {
            cert = this.aliasService.getCertificateForGateway(identityKeyAlias);
        }
        catch (AliasServiceException e) {
            throw new ServiceLifecycleException("Cannot Retreive Gateway SSL Certificate. Server will not start.", (Exception)((Object)e));
        }
        if (cert == null) throw new ServiceLifecycleException("Public certificate for the gateway cannot be found with the alias " + identityKeyAlias + ". Please check the identity certificate alias.");
        if (!(cert instanceof X509Certificate)) throw new ServiceLifecycleException("Public certificate for the gateway is not of the expected type of  . Something is wrong with the gateway keystore.");
        X500Principal x500Principal = ((X509Certificate)cert).getSubjectX500Principal();
        X500PrincipalParser parser = new X500PrincipalParser(x500Principal);
        log.certificateHostNameForGateway(parser.getCN());
        Date notBefore = ((X509Certificate)cert).getNotBefore();
        Date notAfter = ((X509Certificate)cert).getNotAfter();
        log.certificateValidityPeriod(notBefore, notAfter);
        try {
            ((X509Certificate)cert).checkValidity();
            return;
        }
        catch (CertificateExpiredException e) {
            throw new ServiceLifecycleException("Gateway SSL Certificate is Expired. Server will not start.", (Exception)e);
        }
        catch (CertificateNotYetValidException e) {
            throw new ServiceLifecycleException("Gateway SSL Certificate is not yet valid. Server will not start.", (Exception)e);
        }
    }

    public Object buildSslContextFactory(GatewayConfig config) throws AliasServiceException {
        Set sslIncludeProtocols;
        List sslExcludeProtocols;
        List sslExcludeCiphers;
        char[] keypass;
        char[] keystorePasswordChars;
        String identityKeystorePath = config.getIdentityKeystorePath();
        String identityKeystoreType = config.getIdentityKeystoreType();
        String identityKeyAlias = config.getIdentityKeyAlias();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setCertAlias(identityKeyAlias);
        sslContextFactory.setKeyStoreType(identityKeystoreType);
        sslContextFactory.setKeyStorePath(identityKeystorePath);
        try {
            keystorePasswordChars = this.aliasService.getGatewayIdentityKeystorePassword();
        }
        catch (AliasServiceException e) {
            log.failedToGetPasswordForGatewayIdentityKeystore((Exception)((Object)e));
            throw e;
        }
        if (keystorePasswordChars != null) {
            sslContextFactory.setKeyStorePassword(new String(keystorePasswordChars));
        }
        try {
            keypass = this.aliasService.getGatewayIdentityPassphrase();
        }
        catch (AliasServiceException e) {
            log.failedToGetPassphraseForGatewayIdentityKey((Exception)((Object)e));
            throw e;
        }
        if (keypass != null) {
            sslContextFactory.setKeyManagerPassword(new String(keypass));
        }
        boolean clientAuthNeeded = config.isClientAuthNeeded();
        boolean clientAuthWanted = config.isClientAuthWanted();
        if (clientAuthNeeded || clientAuthWanted) {
            char[] truststorePassword;
            String trustStoreType;
            String truststorePath = config.getTruststorePath();
            if (truststorePath != null) {
                String trustStorePasswordAlias = config.getTruststorePasswordAlias();
                trustStoreType = config.getTruststoreType();
                try {
                    truststorePassword = this.aliasService.getPasswordFromAliasForGateway(trustStorePasswordAlias);
                }
                catch (AliasServiceException e) {
                    log.failedToGetPasswordForGatewayTruststore(trustStorePasswordAlias, (Exception)((Object)e));
                    throw e;
                }
            }
            truststorePath = identityKeystorePath;
            trustStoreType = identityKeystoreType;
            try {
                truststorePassword = this.aliasService.getGatewayIdentityKeystorePassword();
            }
            catch (AliasServiceException e) {
                log.failedToGetPasswordForGatewayTruststore(config.getIdentityKeystorePasswordAlias(), (Exception)((Object)e));
                throw e;
            }
            sslContextFactory.setTrustStorePath(truststorePath);
            if (truststorePassword != null) {
                sslContextFactory.setTrustStorePassword(new String(truststorePassword));
            }
            sslContextFactory.setTrustStoreType(trustStoreType);
        }
        if (clientAuthNeeded) {
            sslContextFactory.setNeedClientAuth(clientAuthNeeded);
        } else {
            sslContextFactory.setWantClientAuth(clientAuthWanted);
        }
        sslContextFactory.setTrustAll(config.getTrustAllCerts());
        List sslIncludeCiphers = config.getIncludedSSLCiphers();
        if (sslIncludeCiphers != null && !sslIncludeCiphers.isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(sslIncludeCiphers.toArray(new String[0]));
        }
        if ((sslExcludeCiphers = config.getExcludedSSLCiphers()) != null && !sslExcludeCiphers.isEmpty()) {
            sslContextFactory.setExcludeCipherSuites(sslExcludeCiphers.toArray(new String[0]));
        }
        if ((sslExcludeProtocols = config.getExcludedSSLProtocols()) != null && !sslExcludeProtocols.isEmpty()) {
            sslContextFactory.setExcludeProtocols(sslExcludeProtocols.toArray(new String[0]));
        }
        if ((sslIncludeProtocols = config.getIncludedSSLProtocols()) != null && sslIncludeProtocols.isEmpty()) {
            sslContextFactory.setIncludeProtocols(sslIncludeProtocols.toArray(new String[0]));
        }
        sslContextFactory.setRenegotiationAllowed(config.isSSLRenegotiationAllowed());
        return sslContextFactory;
    }

    public void excludeTopologyFromClientAuth(SslContextFactory sslContextFactory, GatewayConfig config, String topologyName) {
        if (config.isClientAuthNeeded() && config.isTopologyExcludedFromClientAuth(topologyName)) {
            SslContextFactory.Server sslContextFactoryServer = (SslContextFactory.Server)sslContextFactory;
            sslContextFactoryServer.setNeedClientAuth(false);
            sslContextFactoryServer.setWantClientAuth(true);
            log.topologyExcludedFromClientAuth(topologyName);
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }
}

