/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class CachedValueNode
extends ValueNode {
    private ValueNode value;
    private LocalField field;

    CachedValueNode(ValueNode valueNode) {
        super(valueNode.getContextManager());
        this.value = valueNode;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.field == null) {
            this.field = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.types.DataValueDescriptor");
            this.value.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.putField(this.field);
        } else {
            methodBuilder.getField(this.field);
        }
    }

    void generateClearField(MethodBuilder methodBuilder) {
        if (this.field != null) {
            methodBuilder.pushNull("org.apache.derby.iapi.types.DataValueDescriptor");
            methodBuilder.setField(this.field);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.value = this.value.bindExpression(fromList, subqueryList, list);
        return this;
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.value = this.value.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (valueNode instanceof CachedValueNode) {
            CachedValueNode cachedValueNode = (CachedValueNode)valueNode;
            return this.value.isEquivalent(cachedValueNode.value);
        }
        return false;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.value != null) {
            this.value = (ValueNode)this.value.accept(visitor);
        }
    }

    @Override
    DataTypeDescriptor getTypeServices() {
        return this.value.getTypeServices();
    }

    @Override
    void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        this.value.setType(dataTypeDescriptor);
    }

    @Override
    boolean requiresTypeFromContext() {
        return this.value.requiresTypeFromContext();
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.value = this.value.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.value.categorize(jBitSet, bl);
    }
}

