/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiCluster;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiControlPlane;
import com.cloudera.api.swagger.model.ApiControlPlaneList;
import com.cloudera.api.swagger.model.ApiCopyImagesInFeaturesArgs;
import com.cloudera.api.swagger.model.ApiEntityTag;
import com.cloudera.api.swagger.model.ApiGenerateCopyDockerArgs;
import com.cloudera.api.swagger.model.ApiGenerateExternalVaultSetupArgs;
import com.cloudera.api.swagger.model.ApiInstallControlPlaneArgs;
import com.cloudera.api.swagger.model.ApiInstallEmbeddedControlPlaneArgs;
import com.cloudera.api.swagger.model.ApiRemoteRepoUrl;
import com.cloudera.api.swagger.model.ApiUninstallControlPlaneArgs;
import com.cloudera.api.swagger.model.ApiUpdateControlPlaneValuesYamlArgs;
import com.cloudera.api.swagger.model.ApiUpgradeControlPlaneArgs;
import com.cloudera.api.swagger.model.ApiUpgradeEmbeddedControlPlaneArgs;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ControlPlanesResourceApi {
    private ApiClient apiClient;

    public ControlPlanesResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ControlPlanesResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addTagsCall(String controlPlaneUuid, List<ApiEntityTag> body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<ApiEntityTag> localVarPostBody = body;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/tags".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addTagsValidateBeforeCall(String controlPlaneUuid, List<ApiEntityTag> body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling addTags(Async)");
        }
        Call call = this.addTagsCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        return call;
    }

    public List<ApiEntityTag> addTags(String controlPlaneUuid, List<ApiEntityTag> body) throws ApiException {
        ApiResponse<List<ApiEntityTag>> resp = this.addTagsWithHttpInfo(controlPlaneUuid, body);
        return resp.getData();
    }

    public ApiResponse<List<ApiEntityTag>> addTagsWithHttpInfo(String controlPlaneUuid, List<ApiEntityTag> body) throws ApiException {
        Call call = this.addTagsValidateBeforeCall(controlPlaneUuid, body, null, null);
        Type localVarReturnType = new TypeToken<List<ApiEntityTag>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addTagsAsync(String controlPlaneUuid, List<ApiEntityTag> body, final ApiCallback<List<ApiEntityTag>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addTagsValidateBeforeCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ApiEntityTag>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call copyImagesInFeaturesCall(String controlPlaneUuid, ApiCopyImagesInFeaturesArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiCopyImagesInFeaturesArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/commands/copyImagesInFeatures".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyImagesInFeaturesValidateBeforeCall(String controlPlaneUuid, ApiCopyImagesInFeaturesArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling copyImagesInFeatures(Async)");
        }
        Call call = this.copyImagesInFeaturesCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand copyImagesInFeatures(String controlPlaneUuid, ApiCopyImagesInFeaturesArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.copyImagesInFeaturesWithHttpInfo(controlPlaneUuid, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> copyImagesInFeaturesWithHttpInfo(String controlPlaneUuid, ApiCopyImagesInFeaturesArgs body) throws ApiException {
        Call call = this.copyImagesInFeaturesValidateBeforeCall(controlPlaneUuid, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call copyImagesInFeaturesAsync(String controlPlaneUuid, ApiCopyImagesInFeaturesArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyImagesInFeaturesValidateBeforeCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteTagsCall(String controlPlaneUuid, List<ApiEntityTag> body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<ApiEntityTag> localVarPostBody = body;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/tags".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTagsValidateBeforeCall(String controlPlaneUuid, List<ApiEntityTag> body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling deleteTags(Async)");
        }
        Call call = this.deleteTagsCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        return call;
    }

    public List<ApiEntityTag> deleteTags(String controlPlaneUuid, List<ApiEntityTag> body) throws ApiException {
        ApiResponse<List<ApiEntityTag>> resp = this.deleteTagsWithHttpInfo(controlPlaneUuid, body);
        return resp.getData();
    }

    public ApiResponse<List<ApiEntityTag>> deleteTagsWithHttpInfo(String controlPlaneUuid, List<ApiEntityTag> body) throws ApiException {
        Call call = this.deleteTagsValidateBeforeCall(controlPlaneUuid, body, null, null);
        Type localVarReturnType = new TypeToken<List<ApiEntityTag>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteTagsAsync(String controlPlaneUuid, List<ApiEntityTag> body, final ApiCallback<List<ApiEntityTag>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTagsValidateBeforeCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ApiEntityTag>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateCopyDockerCall(ApiGenerateCopyDockerArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiGenerateCopyDockerArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/commands/generateCopyDocker";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateCopyDockerValidateBeforeCall(ApiGenerateCopyDockerArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.generateCopyDockerCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand generateCopyDocker(ApiGenerateCopyDockerArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.generateCopyDockerWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> generateCopyDockerWithHttpInfo(ApiGenerateCopyDockerArgs body) throws ApiException {
        Call call = this.generateCopyDockerValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateCopyDockerAsync(ApiGenerateCopyDockerArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateCopyDockerValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateExternalVaultSetupCall(ApiGenerateExternalVaultSetupArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiGenerateExternalVaultSetupArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/commands/generateExternalVaultSetup";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateExternalVaultSetupValidateBeforeCall(ApiGenerateExternalVaultSetupArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.generateExternalVaultSetupCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand generateExternalVaultSetup(ApiGenerateExternalVaultSetupArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.generateExternalVaultSetupWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> generateExternalVaultSetupWithHttpInfo(ApiGenerateExternalVaultSetupArgs body) throws ApiException {
        Call call = this.generateExternalVaultSetupValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateExternalVaultSetupAsync(ApiGenerateExternalVaultSetupArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateExternalVaultSetupValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getControlPlanesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/controlPlanes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getControlPlanesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getControlPlanesCall(progressListener, progressRequestListener);
        return call;
    }

    public ApiControlPlaneList getControlPlanes() throws ApiException {
        ApiResponse<ApiControlPlaneList> resp = this.getControlPlanesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ApiControlPlaneList> getControlPlanesWithHttpInfo() throws ApiException {
        Call call = this.getControlPlanesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ApiControlPlaneList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getControlPlanesAsync(final ApiCallback<ApiControlPlaneList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getControlPlanesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiControlPlaneList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getExperienceClusterCall(String controlPlaneUuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/getTaggedCluster".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getExperienceClusterValidateBeforeCall(String controlPlaneUuid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling getExperienceCluster(Async)");
        }
        Call call = this.getExperienceClusterCall(controlPlaneUuid, progressListener, progressRequestListener);
        return call;
    }

    public ApiCluster getExperienceCluster(String controlPlaneUuid) throws ApiException {
        ApiResponse<ApiCluster> resp = this.getExperienceClusterWithHttpInfo(controlPlaneUuid);
        return resp.getData();
    }

    public ApiResponse<ApiCluster> getExperienceClusterWithHttpInfo(String controlPlaneUuid) throws ApiException {
        Call call = this.getExperienceClusterValidateBeforeCall(controlPlaneUuid, null, null);
        Type localVarReturnType = new TypeToken<ApiCluster>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getExperienceClusterAsync(String controlPlaneUuid, final ApiCallback<ApiCluster> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getExperienceClusterValidateBeforeCall(controlPlaneUuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCluster>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLogContentCall(BigDecimal commandId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/controlPlanes/fetchResources/{commandId}/logContent".replaceAll("\\{commandId\\}", this.apiClient.escapeString(commandId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLogContentValidateBeforeCall(BigDecimal commandId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (commandId == null) {
            throw new ApiException("Missing the required parameter 'commandId' when calling getLogContent(Async)");
        }
        Call call = this.getLogContentCall(commandId, progressListener, progressRequestListener);
        return call;
    }

    public File getLogContent(BigDecimal commandId) throws ApiException {
        ApiResponse<File> resp = this.getLogContentWithHttpInfo(commandId);
        return resp.getData();
    }

    public ApiResponse<File> getLogContentWithHttpInfo(BigDecimal commandId) throws ApiException {
        Call call = this.getLogContentValidateBeforeCall(commandId, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLogContentAsync(BigDecimal commandId, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLogContentValidateBeforeCall(commandId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getManifestJsonCall(ApiRemoteRepoUrl body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRemoteRepoUrl localVarPostBody = body;
        String localVarPath = "/controlPlanes/fetchResources/manifest.json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getManifestJsonValidateBeforeCall(ApiRemoteRepoUrl body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getManifestJsonCall(body, progressListener, progressRequestListener);
        return call;
    }

    public File getManifestJson(ApiRemoteRepoUrl body) throws ApiException {
        ApiResponse<File> resp = this.getManifestJsonWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<File> getManifestJsonWithHttpInfo(ApiRemoteRepoUrl body) throws ApiException {
        Call call = this.getManifestJsonValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getManifestJsonAsync(ApiRemoteRepoUrl body, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getManifestJsonValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call installControlPlaneCall(ApiInstallControlPlaneArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiInstallControlPlaneArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/commands/installControlPlane";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call installControlPlaneValidateBeforeCall(ApiInstallControlPlaneArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.installControlPlaneCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand installControlPlane(ApiInstallControlPlaneArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.installControlPlaneWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> installControlPlaneWithHttpInfo(ApiInstallControlPlaneArgs body) throws ApiException {
        Call call = this.installControlPlaneValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call installControlPlaneAsync(ApiInstallControlPlaneArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.installControlPlaneValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call installEmbeddedControlPlaneCall(ApiInstallEmbeddedControlPlaneArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiInstallEmbeddedControlPlaneArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/commands/installEmbeddedControlPlane";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call installEmbeddedControlPlaneValidateBeforeCall(ApiInstallEmbeddedControlPlaneArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.installEmbeddedControlPlaneCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand installEmbeddedControlPlane(ApiInstallEmbeddedControlPlaneArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.installEmbeddedControlPlaneWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> installEmbeddedControlPlaneWithHttpInfo(ApiInstallEmbeddedControlPlaneArgs body) throws ApiException {
        Call call = this.installEmbeddedControlPlaneValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call installEmbeddedControlPlaneAsync(ApiInstallEmbeddedControlPlaneArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.installEmbeddedControlPlaneValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readControlPlaneByUuidCall(String controlPlaneUuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readControlPlaneByUuidValidateBeforeCall(String controlPlaneUuid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling readControlPlaneByUuid(Async)");
        }
        Call call = this.readControlPlaneByUuidCall(controlPlaneUuid, progressListener, progressRequestListener);
        return call;
    }

    public ApiControlPlane readControlPlaneByUuid(String controlPlaneUuid) throws ApiException {
        ApiResponse<ApiControlPlane> resp = this.readControlPlaneByUuidWithHttpInfo(controlPlaneUuid);
        return resp.getData();
    }

    public ApiResponse<ApiControlPlane> readControlPlaneByUuidWithHttpInfo(String controlPlaneUuid) throws ApiException {
        Call call = this.readControlPlaneByUuidValidateBeforeCall(controlPlaneUuid, null, null);
        Type localVarReturnType = new TypeToken<ApiControlPlane>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readControlPlaneByUuidAsync(String controlPlaneUuid, final ApiCallback<ApiControlPlane> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readControlPlaneByUuidValidateBeforeCall(controlPlaneUuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiControlPlane>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readTagsCall(String controlPlaneUuid, BigDecimal limit, BigDecimal offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/tags".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readTagsValidateBeforeCall(String controlPlaneUuid, BigDecimal limit, BigDecimal offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling readTags(Async)");
        }
        Call call = this.readTagsCall(controlPlaneUuid, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public List<ApiEntityTag> readTags(String controlPlaneUuid, BigDecimal limit, BigDecimal offset) throws ApiException {
        ApiResponse<List<ApiEntityTag>> resp = this.readTagsWithHttpInfo(controlPlaneUuid, limit, offset);
        return resp.getData();
    }

    public ApiResponse<List<ApiEntityTag>> readTagsWithHttpInfo(String controlPlaneUuid, BigDecimal limit, BigDecimal offset) throws ApiException {
        Call call = this.readTagsValidateBeforeCall(controlPlaneUuid, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<List<ApiEntityTag>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readTagsAsync(String controlPlaneUuid, BigDecimal limit, BigDecimal offset, final ApiCallback<List<ApiEntityTag>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readTagsValidateBeforeCall(controlPlaneUuid, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ApiEntityTag>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call uninstallControlPlaneCall(String controlPlaneUuid, ApiUninstallControlPlaneArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiUninstallControlPlaneArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/commands/uninstallControlPlane".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uninstallControlPlaneValidateBeforeCall(String controlPlaneUuid, ApiUninstallControlPlaneArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling uninstallControlPlane(Async)");
        }
        Call call = this.uninstallControlPlaneCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand uninstallControlPlane(String controlPlaneUuid, ApiUninstallControlPlaneArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.uninstallControlPlaneWithHttpInfo(controlPlaneUuid, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> uninstallControlPlaneWithHttpInfo(String controlPlaneUuid, ApiUninstallControlPlaneArgs body) throws ApiException {
        Call call = this.uninstallControlPlaneValidateBeforeCall(controlPlaneUuid, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uninstallControlPlaneAsync(String controlPlaneUuid, ApiUninstallControlPlaneArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uninstallControlPlaneValidateBeforeCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateValuesYamlCall(String controlPlaneUuid, ApiUpdateControlPlaneValuesYamlArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiUpdateControlPlaneValuesYamlArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/commands/updateControlPlaneValuesYaml".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateValuesYamlValidateBeforeCall(String controlPlaneUuid, ApiUpdateControlPlaneValuesYamlArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling updateValuesYaml(Async)");
        }
        Call call = this.updateValuesYamlCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand updateValuesYaml(String controlPlaneUuid, ApiUpdateControlPlaneValuesYamlArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.updateValuesYamlWithHttpInfo(controlPlaneUuid, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> updateValuesYamlWithHttpInfo(String controlPlaneUuid, ApiUpdateControlPlaneValuesYamlArgs body) throws ApiException {
        Call call = this.updateValuesYamlValidateBeforeCall(controlPlaneUuid, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateValuesYamlAsync(String controlPlaneUuid, ApiUpdateControlPlaneValuesYamlArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateValuesYamlValidateBeforeCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call upgradeControlPlaneCall(String controlPlaneUuid, ApiUpgradeControlPlaneArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiUpgradeControlPlaneArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/{controlPlaneUuid}/commands/upgradeControlPlane".replaceAll("\\{controlPlaneUuid\\}", this.apiClient.escapeString(controlPlaneUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call upgradeControlPlaneValidateBeforeCall(String controlPlaneUuid, ApiUpgradeControlPlaneArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (controlPlaneUuid == null) {
            throw new ApiException("Missing the required parameter 'controlPlaneUuid' when calling upgradeControlPlane(Async)");
        }
        Call call = this.upgradeControlPlaneCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand upgradeControlPlane(String controlPlaneUuid, ApiUpgradeControlPlaneArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.upgradeControlPlaneWithHttpInfo(controlPlaneUuid, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> upgradeControlPlaneWithHttpInfo(String controlPlaneUuid, ApiUpgradeControlPlaneArgs body) throws ApiException {
        Call call = this.upgradeControlPlaneValidateBeforeCall(controlPlaneUuid, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call upgradeControlPlaneAsync(String controlPlaneUuid, ApiUpgradeControlPlaneArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.upgradeControlPlaneValidateBeforeCall(controlPlaneUuid, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call upgradeEmbeddedControlPlaneCall(ApiUpgradeEmbeddedControlPlaneArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiUpgradeEmbeddedControlPlaneArgs localVarPostBody = body;
        String localVarPath = "/controlPlanes/commands/upgradeEmbeddedControlPlane";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call upgradeEmbeddedControlPlaneValidateBeforeCall(ApiUpgradeEmbeddedControlPlaneArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.upgradeEmbeddedControlPlaneCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand upgradeEmbeddedControlPlane(ApiUpgradeEmbeddedControlPlaneArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.upgradeEmbeddedControlPlaneWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> upgradeEmbeddedControlPlaneWithHttpInfo(ApiUpgradeEmbeddedControlPlaneArgs body) throws ApiException {
        Call call = this.upgradeEmbeddedControlPlaneValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call upgradeEmbeddedControlPlaneAsync(ApiUpgradeEmbeddedControlPlaneArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.upgradeEmbeddedControlPlaneValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

