/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiHostRefList;
import com.cloudera.api.swagger.model.ApiHostTemplate;
import com.cloudera.api.swagger.model.ApiHostTemplateList;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HostTemplatesResourceApi {
    private ApiClient apiClient;

    public HostTemplatesResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HostTemplatesResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applyHostTemplateCall(String clusterName, String hostTemplateName, ApiHostRefList body, Boolean runConfigRules, Boolean startRoles, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHostRefList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/hostTemplates/{hostTemplateName}/commands/applyHostTemplate".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{hostTemplateName\\}", this.apiClient.escapeString(hostTemplateName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (runConfigRules != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("runConfigRules", runConfigRules));
        }
        if (startRoles != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startRoles", startRoles));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applyHostTemplateValidateBeforeCall(String clusterName, String hostTemplateName, ApiHostRefList body, Boolean runConfigRules, Boolean startRoles, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling applyHostTemplate(Async)");
        }
        if (hostTemplateName == null) {
            throw new ApiException("Missing the required parameter 'hostTemplateName' when calling applyHostTemplate(Async)");
        }
        Call call = this.applyHostTemplateCall(clusterName, hostTemplateName, body, runConfigRules, startRoles, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand applyHostTemplate(String clusterName, String hostTemplateName, ApiHostRefList body, Boolean runConfigRules, Boolean startRoles) throws ApiException {
        ApiResponse<ApiCommand> resp = this.applyHostTemplateWithHttpInfo(clusterName, hostTemplateName, body, runConfigRules, startRoles);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> applyHostTemplateWithHttpInfo(String clusterName, String hostTemplateName, ApiHostRefList body, Boolean runConfigRules, Boolean startRoles) throws ApiException {
        Call call = this.applyHostTemplateValidateBeforeCall(clusterName, hostTemplateName, body, runConfigRules, startRoles, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applyHostTemplateAsync(String clusterName, String hostTemplateName, ApiHostRefList body, Boolean runConfigRules, Boolean startRoles, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applyHostTemplateValidateBeforeCall(clusterName, hostTemplateName, body, runConfigRules, startRoles, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createHostTemplatesCall(String clusterName, ApiHostTemplateList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHostTemplateList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/hostTemplates".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createHostTemplatesValidateBeforeCall(String clusterName, ApiHostTemplateList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createHostTemplates(Async)");
        }
        Call call = this.createHostTemplatesCall(clusterName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiHostTemplateList createHostTemplates(String clusterName, ApiHostTemplateList body) throws ApiException {
        ApiResponse<ApiHostTemplateList> resp = this.createHostTemplatesWithHttpInfo(clusterName, body);
        return resp.getData();
    }

    public ApiResponse<ApiHostTemplateList> createHostTemplatesWithHttpInfo(String clusterName, ApiHostTemplateList body) throws ApiException {
        Call call = this.createHostTemplatesValidateBeforeCall(clusterName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiHostTemplateList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createHostTemplatesAsync(String clusterName, ApiHostTemplateList body, final ApiCallback<ApiHostTemplateList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createHostTemplatesValidateBeforeCall(clusterName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiHostTemplateList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteHostTemplateCall(String clusterName, String hostTemplateName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/hostTemplates/{hostTemplateName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{hostTemplateName\\}", this.apiClient.escapeString(hostTemplateName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteHostTemplateValidateBeforeCall(String clusterName, String hostTemplateName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deleteHostTemplate(Async)");
        }
        if (hostTemplateName == null) {
            throw new ApiException("Missing the required parameter 'hostTemplateName' when calling deleteHostTemplate(Async)");
        }
        Call call = this.deleteHostTemplateCall(clusterName, hostTemplateName, progressListener, progressRequestListener);
        return call;
    }

    public ApiHostTemplate deleteHostTemplate(String clusterName, String hostTemplateName) throws ApiException {
        ApiResponse<ApiHostTemplate> resp = this.deleteHostTemplateWithHttpInfo(clusterName, hostTemplateName);
        return resp.getData();
    }

    public ApiResponse<ApiHostTemplate> deleteHostTemplateWithHttpInfo(String clusterName, String hostTemplateName) throws ApiException {
        Call call = this.deleteHostTemplateValidateBeforeCall(clusterName, hostTemplateName, null, null);
        Type localVarReturnType = new TypeToken<ApiHostTemplate>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteHostTemplateAsync(String clusterName, String hostTemplateName, final ApiCallback<ApiHostTemplate> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteHostTemplateValidateBeforeCall(clusterName, hostTemplateName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiHostTemplate>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readHostTemplateCall(String clusterName, String hostTemplateName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/hostTemplates/{hostTemplateName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{hostTemplateName\\}", this.apiClient.escapeString(hostTemplateName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readHostTemplateValidateBeforeCall(String clusterName, String hostTemplateName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readHostTemplate(Async)");
        }
        if (hostTemplateName == null) {
            throw new ApiException("Missing the required parameter 'hostTemplateName' when calling readHostTemplate(Async)");
        }
        Call call = this.readHostTemplateCall(clusterName, hostTemplateName, progressListener, progressRequestListener);
        return call;
    }

    public ApiHostTemplate readHostTemplate(String clusterName, String hostTemplateName) throws ApiException {
        ApiResponse<ApiHostTemplate> resp = this.readHostTemplateWithHttpInfo(clusterName, hostTemplateName);
        return resp.getData();
    }

    public ApiResponse<ApiHostTemplate> readHostTemplateWithHttpInfo(String clusterName, String hostTemplateName) throws ApiException {
        Call call = this.readHostTemplateValidateBeforeCall(clusterName, hostTemplateName, null, null);
        Type localVarReturnType = new TypeToken<ApiHostTemplate>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readHostTemplateAsync(String clusterName, String hostTemplateName, final ApiCallback<ApiHostTemplate> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readHostTemplateValidateBeforeCall(clusterName, hostTemplateName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiHostTemplate>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readHostTemplatesCall(String clusterName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/hostTemplates".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readHostTemplatesValidateBeforeCall(String clusterName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readHostTemplates(Async)");
        }
        Call call = this.readHostTemplatesCall(clusterName, progressListener, progressRequestListener);
        return call;
    }

    public ApiHostTemplateList readHostTemplates(String clusterName) throws ApiException {
        ApiResponse<ApiHostTemplateList> resp = this.readHostTemplatesWithHttpInfo(clusterName);
        return resp.getData();
    }

    public ApiResponse<ApiHostTemplateList> readHostTemplatesWithHttpInfo(String clusterName) throws ApiException {
        Call call = this.readHostTemplatesValidateBeforeCall(clusterName, null, null);
        Type localVarReturnType = new TypeToken<ApiHostTemplateList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readHostTemplatesAsync(String clusterName, final ApiCallback<ApiHostTemplateList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readHostTemplatesValidateBeforeCall(clusterName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiHostTemplateList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call reapplyHostTemplateOnHostsCall(String clusterName, String hostTemplateName, Boolean deleteRoles, Boolean startRoles, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/hostTemplates/{hostTemplateName}/commands/reapplyHostTemplateOnHosts".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{hostTemplateName\\}", this.apiClient.escapeString(hostTemplateName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (deleteRoles != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("deleteRoles", deleteRoles));
        }
        if (startRoles != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startRoles", startRoles));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call reapplyHostTemplateOnHostsValidateBeforeCall(String clusterName, String hostTemplateName, Boolean deleteRoles, Boolean startRoles, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling reapplyHostTemplateOnHosts(Async)");
        }
        if (hostTemplateName == null) {
            throw new ApiException("Missing the required parameter 'hostTemplateName' when calling reapplyHostTemplateOnHosts(Async)");
        }
        Call call = this.reapplyHostTemplateOnHostsCall(clusterName, hostTemplateName, deleteRoles, startRoles, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand reapplyHostTemplateOnHosts(String clusterName, String hostTemplateName, Boolean deleteRoles, Boolean startRoles) throws ApiException {
        ApiResponse<ApiCommand> resp = this.reapplyHostTemplateOnHostsWithHttpInfo(clusterName, hostTemplateName, deleteRoles, startRoles);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> reapplyHostTemplateOnHostsWithHttpInfo(String clusterName, String hostTemplateName, Boolean deleteRoles, Boolean startRoles) throws ApiException {
        Call call = this.reapplyHostTemplateOnHostsValidateBeforeCall(clusterName, hostTemplateName, deleteRoles, startRoles, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call reapplyHostTemplateOnHostsAsync(String clusterName, String hostTemplateName, Boolean deleteRoles, Boolean startRoles, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.reapplyHostTemplateOnHostsValidateBeforeCall(clusterName, hostTemplateName, deleteRoles, startRoles, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateHostTemplateCall(String clusterName, String hostTemplateName, ApiHostTemplate body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHostTemplate localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/hostTemplates/{hostTemplateName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{hostTemplateName\\}", this.apiClient.escapeString(hostTemplateName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateHostTemplateValidateBeforeCall(String clusterName, String hostTemplateName, ApiHostTemplate body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateHostTemplate(Async)");
        }
        if (hostTemplateName == null) {
            throw new ApiException("Missing the required parameter 'hostTemplateName' when calling updateHostTemplate(Async)");
        }
        Call call = this.updateHostTemplateCall(clusterName, hostTemplateName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiHostTemplate updateHostTemplate(String clusterName, String hostTemplateName, ApiHostTemplate body) throws ApiException {
        ApiResponse<ApiHostTemplate> resp = this.updateHostTemplateWithHttpInfo(clusterName, hostTemplateName, body);
        return resp.getData();
    }

    public ApiResponse<ApiHostTemplate> updateHostTemplateWithHttpInfo(String clusterName, String hostTemplateName, ApiHostTemplate body) throws ApiException {
        Call call = this.updateHostTemplateValidateBeforeCall(clusterName, hostTemplateName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiHostTemplate>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateHostTemplateAsync(String clusterName, String hostTemplateName, ApiHostTemplate body, final ApiCallback<ApiHostTemplate> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateHostTemplateValidateBeforeCall(clusterName, hostTemplateName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiHostTemplate>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

