/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiCommandStep;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Provides detailed information about a submitted command including all steps and a summary of subcommands.  <p>There are two types of commands: synchronous and asynchronous. Synchronous commands complete immediately, and their results are passed back in the returned command object after the execution of an API call. Outside of that returned object, there is no way to check the result of a synchronous command.</p>  <p>Asynchronous commands have unique non-negative IDs. They may still be running when the API call returns. Clients can check the status of such commands using the API.</p>")
public class ApiCommandWithSteps
extends ApiCommand {
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="steps")
    private List<ApiCommandStep> steps = null;

    public ApiCommandWithSteps displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="The command display name.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiCommandWithSteps steps(List<ApiCommandStep> steps) {
        this.steps = steps;
        return this;
    }

    public ApiCommandWithSteps addStepsItem(ApiCommandStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<ApiCommandStep>();
        }
        this.steps.add(stepsItem);
        return this;
    }

    @Schema(description="The steps of the command.")
    public List<ApiCommandStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<ApiCommandStep> steps) {
        this.steps = steps;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCommandWithSteps apiCommandWithSteps = (ApiCommandWithSteps)o;
        return Objects.equals(this.displayName, apiCommandWithSteps.displayName) && Objects.equals(this.steps, apiCommandWithSteps.steps) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.displayName, this.steps, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCommandWithSteps {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

