<!-- vim: set syn=markdown : -->
<!--
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
-->

# Log4j 2 Javadoc API Documentation and TLD Documentation

## Javadoc API Documentation

The table below contains links to the Javadoc API Documentation for the components you are most likely to use
directly in code. You can also use the menu links on the left.

Component | Description
--------- | -----------
[Log4j Audit API](/log4j-audit/log4j-audit-api/apidocs/index.html) | The interface that applications should use and code against.
[Audit Service](log4j-audit/log4j-audit-war/apidocs/index.html) | The standard implementation, also called the Log4j 2 Core, that contains Appenders, Filters, and more.
[Maven Plugin](log4j-audit/log4j-audit-maven-plugin/apidocs/index.html) | Extra classes for dealing with older APIs that expect classes from `java.io` for logging.
[Catalog API](log4j-catalog/log4j-catalog-api/apidocs/index.html) | The tag library that enables Java-free logging in JavaServer Pages™ using Log4j 2.
[Git Catalog Access](log4j-catalog/log4j-catalog-git/apidocs/index.html) | The special Javadoc-like Tag Library Documentation for the Log4j 2 JSP Tag Library.
[JPA Catalog Access](log4j-catalog/log4j-catalog-jpa/apidocs/index.html) |
[Catalog Editor](log4j-catalog/log4j-catalog-war/apidocs/index.html) |
