/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.docgen.AbstractType;
import org.apache.logging.log4j.docgen.Description;
import org.apache.logging.log4j.docgen.PluginAttribute;
import org.apache.logging.log4j.docgen.PluginElement;
import org.apache.logging.log4j.docgen.PluginType;
import org.apache.logging.log4j.docgen.ScalarType;
import org.apache.logging.log4j.docgen.ScalarValue;
import org.apache.logging.log4j.docgen.Type;
import org.apache.logging.log4j.docgen.generator.BaseTypes;
import org.apache.logging.log4j.docgen.generator.SchemaGeneratorArgs;
import org.apache.logging.log4j.docgen.generator.internal.ArtifactSourcedType;
import org.apache.logging.log4j.docgen.generator.internal.TypeLookup;
import org.jspecify.annotations.Nullable;

@Singleton
@Named(value="default")
public final class SchemaGenerator {
    private static final String LOG4J_PREFIX = "log4j";
    private static final String LOG4J_NAMESPACE = "https://logging.apache.org/xml/ns";
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String MULTIPLICITY_UNBOUNDED = "*";
    private static final String CHARSET_NAME = "UTF-8";

    private SchemaGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSchema(SchemaGeneratorArgs args) throws XMLStreamException {
        Objects.requireNonNull(args, "args");
        try {
            List extendedSets = Stream.concat(BaseTypes.PLUGIN_SETS.stream(), args.pluginSets.stream()).collect(Collectors.toList());
            TypeLookup lookup = TypeLookup.of(extendedSets, args.classNameFilter);
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            @Nullable Path schemaFileParent = args.schemaFile.getParent();
            if (schemaFileParent != null) {
                Files.createDirectories(schemaFileParent, new FileAttribute[0]);
            }
            try (OutputStream schemaPathOutputStream = Files.newOutputStream(args.schemaFile, new OpenOption[0]);
                 XMLStreamWriter writer = factory.createXMLStreamWriter(schemaPathOutputStream, CHARSET_NAME);){
                SchemaGenerator.writeSchema(args.schemaVersion, lookup, writer);
            }
        }
        catch (IOException error) {
            throw new XMLStreamException(error);
        }
    }

    private static void writeSchema(String version, TypeLookup lookup, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument(CHARSET_NAME, "1.0");
        writer.setDefaultNamespace(XSD_NAMESPACE);
        writer.writeStartElement(XSD_NAMESPACE, "schema");
        writer.writeDefaultNamespace(XSD_NAMESPACE);
        writer.writeNamespace(LOG4J_PREFIX, LOG4J_NAMESPACE);
        writer.writeAttribute("elementFormDefault", "qualified");
        writer.writeAttribute("targetNamespace", LOG4J_NAMESPACE);
        writer.writeAttribute("version", version);
        writer.writeEmptyElement(XSD_NAMESPACE, "element");
        writer.writeAttribute("type", "log4j:org.apache.logging.log4j.core.config.Configuration");
        writer.writeAttribute("name", "Configuration");
        SchemaGenerator.writeTypes(lookup, writer);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private static void writeTypes(TypeLookup lookup, XMLStreamWriter writer) throws XMLStreamException {
        for (ArtifactSourcedType sourcedType : lookup.values()) {
            Type type = sourcedType.type;
            if (SchemaGenerator.isBuiltinXmlType(type.getClassName())) continue;
            if (type instanceof ScalarType) {
                SchemaGenerator.writeScalarType((ScalarType)type, writer);
            }
            if (type instanceof PluginType) {
                PluginType pluginType = (PluginType)type;
                SchemaGenerator.writePluginType(lookup, pluginType, writer);
                if (pluginType.getAliases().isEmpty() && pluginType.getImplementations().isEmpty()) continue;
                SchemaGenerator.writeAbstractType(lookup, pluginType, writer);
                continue;
            }
            if (!(type instanceof AbstractType)) continue;
            SchemaGenerator.writeAbstractType(lookup, (AbstractType)type, writer);
        }
    }

    private static boolean isBuiltinXmlType(String className) {
        switch (className) {
            case "boolean": 
            case "byte": 
            case "double": 
            case "float": 
            case "int": 
            case "short": 
            case "long": 
            case "java.lang.String": {
                return true;
            }
        }
        return false;
    }

    private static void writeScalarType(ScalarType type, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XSD_NAMESPACE, "simpleType");
        writer.writeAttribute("name", type.getClassName());
        SchemaGenerator.writeDocumentation(type.getDescription(), writer);
        writer.writeStartElement(XSD_NAMESPACE, "restriction");
        writer.writeAttribute("base", "string");
        for (ScalarValue value : type.getValues()) {
            SchemaGenerator.writeScalarValue(value, writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writePluginType(TypeLookup lookup, PluginType pluginType, XMLStreamWriter writer) throws XMLStreamException {
        boolean hasComplexContent;
        writer.writeStartElement(XSD_NAMESPACE, "complexType");
        writer.writeAttribute("name", pluginType.getClassName());
        SchemaGenerator.writeDocumentation(pluginType.getDescription(), writer);
        boolean bl = hasComplexContent = !pluginType.getElements().isEmpty();
        if (hasComplexContent) {
            writer.writeStartElement(XSD_NAMESPACE, "sequence");
            for (PluginElement element : pluginType.getElements()) {
                SchemaGenerator.writePluginElement(lookup, element, writer);
            }
            writer.writeEndElement();
        }
        for (PluginAttribute attribute : pluginType.getAttributes()) {
            SchemaGenerator.writePluginAttribute(lookup, attribute, writer);
        }
        writer.writeEndElement();
    }

    private static void writeAbstractType(TypeLookup lookup, AbstractType abstractType, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XSD_NAMESPACE, "group");
        writer.writeAttribute("name", abstractType.getClassName());
        SchemaGenerator.writeDocumentation(abstractType.getDescription(), writer);
        writer.writeStartElement(XSD_NAMESPACE, "choice");
        Set<String> implementations = abstractType.getImplementations();
        if (abstractType instanceof PluginType) {
            implementations.add(abstractType.getClassName());
        }
        for (String implementation : implementations) {
            @Nullable ArtifactSourcedType sourcedType = (ArtifactSourcedType)lookup.get(implementation);
            if (sourcedType == null || !(sourcedType.type instanceof PluginType)) continue;
            PluginType pluginType = (PluginType)sourcedType.type;
            for (String key : SchemaGenerator.getKeyAndAliases(pluginType)) {
                writer.writeEmptyElement(XSD_NAMESPACE, "element");
                writer.writeAttribute("name", key);
                writer.writeAttribute("type", "log4j:" + pluginType.getClassName());
            }
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void writeDocumentation(@Nullable Description description, XMLStreamWriter writer) throws XMLStreamException {
        if (description != null) {
            writer.writeStartElement(XSD_NAMESPACE, "annotation");
            writer.writeStartElement(XSD_NAMESPACE, "documentation");
            writer.writeCharacters(description.getText());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private static void writeScalarValue(ScalarValue value, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XSD_NAMESPACE, "enumeration");
        writer.writeAttribute("value", value.getName());
        SchemaGenerator.writeDocumentation(value.getDescription(), writer);
        writer.writeEndElement();
    }

    private static void writePluginElement(TypeLookup lookup, PluginElement element, XMLStreamWriter writer) throws XMLStreamException {
        PluginType pluginType;
        String type = element.getType();
        @Nullable String xmlType = SchemaGenerator.getXmlType(lookup, type);
        if (xmlType == null) {
            return;
        }
        ArtifactSourcedType sourcedType = (ArtifactSourcedType)lookup.get(type);
        if (sourcedType == null) {
            return;
        }
        Type rawType = sourcedType.type;
        if (!(rawType instanceof AbstractType)) {
            return;
        }
        AbstractType abstractType = (AbstractType)rawType;
        PluginType pluginType2 = pluginType = abstractType instanceof PluginType ? (PluginType)abstractType : null;
        if (pluginType == null || !pluginType.getAliases().isEmpty() || !pluginType.getImplementations().isEmpty()) {
            writer.writeStartElement(XSD_NAMESPACE, "group");
            writer.writeAttribute("ref", xmlType);
            SchemaGenerator.writeMultiplicity(element.isRequired(), element.getMultiplicity(), writer);
            SchemaGenerator.writeDocumentation(element.getDescription(), writer);
            writer.writeEndElement();
        } else {
            for (String key : SchemaGenerator.getKeyAndAliases(pluginType)) {
                writer.writeStartElement(XSD_NAMESPACE, "element");
                writer.writeAttribute("name", key);
                writer.writeAttribute("type", xmlType);
                SchemaGenerator.writeMultiplicity(element.isRequired(), element.getMultiplicity(), writer);
                SchemaGenerator.writeDocumentation(element.getDescription(), writer);
                writer.writeEndElement();
            }
        }
    }

    private static void writePluginAttribute(TypeLookup lookup, PluginAttribute attribute, XMLStreamWriter writer) throws XMLStreamException {
        @Nullable String xmlType = SchemaGenerator.getXmlType(lookup, attribute.getType());
        if (xmlType == null) {
            return;
        }
        writer.writeStartElement(XSD_NAMESPACE, "attribute");
        writer.writeAttribute("name", attribute.getName());
        writer.writeAttribute("type", xmlType);
        Description description = attribute.getDescription();
        if (description != null) {
            SchemaGenerator.writeDocumentation(description, writer);
        }
        writer.writeEndElement();
    }

    private static @Nullable String getXmlType(TypeLookup lookup, String className) {
        switch (className) {
            case "boolean": 
            case "byte": 
            case "double": 
            case "float": 
            case "int": 
            case "short": 
            case "long": {
                return className;
            }
            case "java.lang.String": {
                return "string";
            }
        }
        ArtifactSourcedType type = (ArtifactSourcedType)lookup.get(className);
        if (type != null) {
            return "log4j:" + className;
        }
        return null;
    }

    private static void writeMultiplicity(boolean required, String multiplicity, XMLStreamWriter writer) throws XMLStreamException {
        if (!required) {
            writer.writeAttribute("minOccurs", "0");
        }
        if (MULTIPLICITY_UNBOUNDED.equals(multiplicity)) {
            writer.writeAttribute("maxOccurs", "unbounded");
        }
    }

    private static Collection<String> getKeyAndAliases(PluginType pluginType) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(pluginType.getName());
        keys.addAll(pluginType.getAliases());
        return keys;
    }
}

