/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.generator.internal;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.docgen.AbstractType;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.PluginType;
import org.apache.logging.log4j.docgen.ScalarType;
import org.apache.logging.log4j.docgen.Type;
import org.apache.logging.log4j.docgen.generator.internal.ArtifactSourcedType;
import org.jspecify.annotations.Nullable;

public final class TypeLookup
extends TreeMap<String, ArtifactSourcedType> {
    private static final long serialVersionUID = 1L;

    public static TypeLookup of(Iterable<? extends PluginSet> pluginSets, Predicate<String> classNameFilter) {
        return new TypeLookup(pluginSets, classNameFilter);
    }

    private TypeLookup(Iterable<? extends PluginSet> pluginSets, Predicate<String> classNameFilter) {
        this.mergeDescriptors(pluginSets);
        this.populateTypeHierarchy(pluginSets);
        this.filterTypes(classNameFilter);
    }

    private void mergeDescriptors(Iterable<? extends PluginSet> pluginSets) {
        pluginSets.forEach((? super T pluginSet) -> {
            this.mergeScalarTypes((PluginSet)pluginSet);
            this.mergeAbstractTypes((PluginSet)pluginSet);
            this.mergePluginTypes((PluginSet)pluginSet);
        });
    }

    private void mergeScalarTypes(PluginSet pluginSet) {
        pluginSet.getScalars().forEach((? super T newType) -> {
            String className = newType.getClassName();
            ArtifactSourcedType newSourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, newType);
            this.merge(className, newSourcedType, TypeLookup::mergeScalarType);
        });
    }

    private static ArtifactSourcedType mergeScalarType(ArtifactSourcedType oldSourcedType, ArtifactSourcedType newSourcedType) {
        if (oldSourcedType.type instanceof ScalarType) {
            return oldSourcedType;
        }
        throw TypeLookup.conflictingTypeFailure(oldSourcedType.type, newSourcedType.type);
    }

    private static RuntimeException conflictingTypeFailure(Type oldType, Type newType) {
        String message = String.format("`%s` class occurs multiple times with conflicting types: `%s` and `%s`", oldType.getClassName(), oldType.getClass().getSimpleName(), newType.getClass().getSimpleName());
        return new IllegalArgumentException(message);
    }

    private void mergeAbstractTypes(PluginSet pluginSet) {
        pluginSet.getAbstractTypes().forEach((? super T newType) -> {
            String className = newType.getClassName();
            ArtifactSourcedType newSourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, newType);
            this.merge(className, newSourcedType, TypeLookup::mergeAbstractType);
        });
    }

    private static ArtifactSourcedType mergeAbstractType(ArtifactSourcedType oldSourcedType, ArtifactSourcedType newSourcedType) {
        if (oldSourcedType.type instanceof AbstractType) {
            AbstractType oldType = (AbstractType)oldSourcedType.type;
            AbstractType newType = (AbstractType)newSourcedType.type;
            newType.getImplementations().forEach(oldType::addImplementation);
            return oldSourcedType;
        }
        throw TypeLookup.conflictingTypeFailure(oldSourcedType.type, newSourcedType.type);
    }

    private void mergePluginTypes(PluginSet pluginSet) {
        pluginSet.getPlugins().forEach((? super T newType) -> {
            String className = newType.getClassName();
            ArtifactSourcedType newSourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, newType);
            this.merge(className, newSourcedType, TypeLookup::mergePluginType);
        });
    }

    private static ArtifactSourcedType mergePluginType(ArtifactSourcedType oldSourcedType, ArtifactSourcedType newSourcedType) {
        if (oldSourcedType.type instanceof AbstractType && !(oldSourcedType.type instanceof PluginType)) {
            PluginType newType = (PluginType)newSourcedType.type;
            AbstractType oldType = (AbstractType)oldSourcedType.type;
            oldType.getImplementations().forEach(newType::addImplementation);
            return newSourcedType;
        }
        if (oldSourcedType.type instanceof PluginType) {
            PluginType oldType = (PluginType)oldSourcedType.type;
            PluginType newType = (PluginType)newSourcedType.type;
            newType.getImplementations().forEach(oldType::addImplementation);
            return oldSourcedType;
        }
        throw TypeLookup.conflictingTypeFailure(oldSourcedType.type, newSourcedType.type);
    }

    private void populateTypeHierarchy(Iterable<? extends PluginSet> pluginSets) {
        pluginSets.forEach((? super T pluginSet) -> {
            Set<PluginType> pluginTypes = pluginSet.getPlugins();
            pluginTypes.forEach((? super T plugin) -> {
                Set<String> superTypeClassNames = plugin.getSupertypes();
                superTypeClassNames.forEach((? super T superTypeClassName) -> {
                    AbstractType sourcedSuperType = this.getOrPutAbstractType((String)superTypeClassName, (PluginSet)pluginSet);
                    sourcedSuperType.addImplementation(plugin.getClassName());
                });
            });
        });
    }

    private @Nullable AbstractType getOrPutAbstractType(String className, PluginSet pluginSet) {
        @Nullable ArtifactSourcedType foundSourcedType = (ArtifactSourcedType)this.get(className);
        if (foundSourcedType != null) {
            return (AbstractType)foundSourcedType.type;
        }
        AbstractType type = new AbstractType();
        type.setClassName(className);
        ArtifactSourcedType sourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, type);
        this.put(className, sourcedType);
        return type;
    }

    private void filterTypes(Predicate<String> classNameMatcher) {
        Iterator classNameIterator = this.keySet().iterator();
        while (classNameIterator.hasNext()) {
            String className = (String)classNameIterator.next();
            boolean matching = classNameMatcher.test(className);
            if (matching) continue;
            classNameIterator.remove();
        }
    }
}

