/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.FactoryResolver;
import org.apache.logging.log4j.plugins.di.spi.InjectionPoint;
import org.apache.logging.log4j.plugins.di.spi.ResolvableKey;
import org.apache.logging.log4j.plugins.di.spi.StringValueResolver;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.Nullable;

public abstract class AbstractAttributeFactoryResolver<T, A extends Annotation>
implements FactoryResolver<T> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected final Class<A> annotationType;

    protected AbstractAttributeFactoryResolver(Class<A> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public boolean supportsKey(Key<?> key) {
        return key.getQualifierType() == this.annotationType;
    }

    @Override
    public Supplier<T> getFactory(ResolvableKey<T> resolvableKey, InstanceFactory instanceFactory) {
        InjectionPoint<?> injectionPoint = instanceFactory.getInstance(InjectionPoint.CURRENT_INJECTION_POINT);
        return () -> {
            Key key = resolvableKey.key();
            Type type = key.getType();
            TypeConverter typeConverter = instanceFactory.getTypeConverter(type);
            AnnotatedElement element = injectionPoint.element();
            A annotation = element.getAnnotation(this.annotationType);
            boolean sensitive = this.isSensitive(annotation);
            Node node = instanceFactory.getInstance(Node.CURRENT_NODE);
            StringValueResolver resolver = instanceFactory.hasBinding(StringValueResolver.KEY) ? instanceFactory.getInstance(StringValueResolver.KEY) : StringValueResolver.NOOP;
            LOGGER.trace("Configuring node {} attribute {}", (Object)node.getName(), key);
            String attribute = node.removeMatchingAttribute(key.getName(), resolvableKey.aliases()).map(resolver::resolve).orElse(null);
            if (attribute != null) {
                LOGGER.trace("Configured node {} {}={}", (Object)node.getName(), key, (Object)(sensitive ? "(sensitive)" : attribute));
                return typeConverter.convert(attribute, null, sensitive);
            }
            @Nullable T defaultValue = this.getDefaultValue(annotation, resolver, type, typeConverter);
            LOGGER.trace("Configured node {} {}={} (default value)", (Object)node.getName(), key, defaultValue);
            return defaultValue;
        };
    }

    protected abstract boolean isSensitive(A var1);

    protected abstract @Nullable T getDefaultValue(A var1, StringValueResolver var2, Type var3, TypeConverter<T> var4);
}

