/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.test.junit.Log4jExtension;
import org.apache.logging.log4j.plugins.di.Keys;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class AppenderResolver
implements ParameterResolver {
    AppenderResolver() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return Appender.class.isAssignableFrom(parameter.getType()) && Keys.hasName((AnnotatedElement)parameter);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        LoggerContext loggerContext = Log4jExtension.getRequiredLoggerContext(extensionContext);
        String name = Keys.getName((Parameter)parameterContext.getParameter());
        if (name.isEmpty()) {
            throw new ParameterResolutionException("No named annotation present after checking earlier");
        }
        Appender appender = loggerContext.getConfiguration().getAppender(name);
        if (appender == null) {
            throw new ParameterResolutionException("No appender named " + name);
        }
        return appender;
    }
}

