/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.internal;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.kit.env.PropertySource;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.Nullable;

public class ContextualEnvironmentPropertySource
implements PropertySource {
    private static final Pattern PROPERTY_TOKENIZER = Pattern.compile("([A-Z]?[a-z0-9]+|[A-Z0-9]+)\\.?");
    private static final int DEFAULT_PRIORITY = 0;
    private final String prefix;
    private final int priority;

    public ContextualEnvironmentPropertySource(String contextName) {
        this(contextName, 0);
    }

    public ContextualEnvironmentPropertySource(String contextName, int priority) {
        this.prefix = "LOG4J_CONTEXTS_" + contextName.toUpperCase(Locale.ROOT);
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public @Nullable String getProperty(String key) {
        String actualKey = this.getNormalForm(key);
        try {
            return System.getenv(actualKey);
        }
        catch (SecurityException e) {
            StatusLogger.getLogger().warn("{} lacks permissions to access system property {}.", (Object)this.getClass().getName(), (Object)actualKey, (Object)e);
            return null;
        }
    }

    private String getNormalForm(CharSequence key) {
        StringBuilder sb = new StringBuilder(this.prefix);
        Matcher matcher = PROPERTY_TOKENIZER.matcher(key);
        int start = 0;
        while (matcher.find(start)) {
            start = matcher.end();
            sb.append('_').append(matcher.group(1).toUpperCase(Locale.ROOT));
        }
        return sb.toString();
    }
}

