<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: default
title: TF-IDF - Term Frequency-Inverse Document Frequency

    
---

{excerpt}Is a weight measure often used in information retrieval and text
mining. This weight is a statistical measure used to evaluate how important
a word is to a document in a collection or corpus. The importance increases
proportionally to the number of times a word appears in the document but is
offset by the frequency of the word in the corpus.{excerpt} In other words
if a term/word appears lots in a document but also appears lots in the
corpus/collection as a whole it will get a lower score. An example of this
would be "the", "and", "it" but depending on your source material it maybe
other words that are very common to the source matter.


 See Also:
 * http://en.wikipedia.org/wiki/Tf%E2%80%93idf
 * http://nlp.stanford.edu/IR-book/html/htmledition/tf-idf-weighting-1.html
